/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.builder;

import java.util.Objects;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.parameter.managed.ValueParameter;
import org.spongepowered.api.command.parameter.managed.standard.VariableValueParameters;
import org.spongepowered.common.command.parameter.managed.standard.SpongeTextValueParameter;
import org.spongepowered.common.util.Preconditions;

public final class SpongeTextParameterBuilder
implements VariableValueParameters.TextBuilder {
    private @Nullable ComponentSerializer<Component, ? extends Component, String> textSerializer;
    private boolean consumeAllArguments;

    @Override
    public  @NonNull VariableValueParameters.TextBuilder serializer(@NonNull ComponentSerializer<Component, ? extends Component, String> serializer) {
        Objects.requireNonNull(serializer, "The serializer cannot be null");
        return this.serializerSupplier(() -> serializer);
    }

    @Override
    public  @NonNull VariableValueParameters.TextBuilder serializerSupplier(@NonNull Supplier<ComponentSerializer<Component, ? extends Component, String>> serializerSupplier) {
        this.textSerializer = serializerSupplier.get();
        return this;
    }

    @Override
    public  @NonNull VariableValueParameters.TextBuilder consumeAllArguments(boolean allArguments) {
        this.consumeAllArguments = allArguments;
        return this;
    }

    @Override
    public ValueParameter<Component> build() throws IllegalStateException {
        Preconditions.checkState(this.textSerializer != null, "Text Serializer cannot be null.");
        return new SpongeTextValueParameter(this.textSerializer, this.consumeAllArguments);
    }

    @Override
    public VariableValueParameters.TextBuilder reset() {
        this.textSerializer = null;
        this.consumeAllArguments = false;
        return this;
    }
}

