/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.builder.meta;

import java.util.Objects;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.meta.BannerPatternLayer;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.type.BannerPatternShape;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.data.meta.SpongePatternLayer;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.Preconditions;

public final class SpongePatternLayerBuilder
extends AbstractDataBuilder<BannerPatternLayer>
implements BannerPatternLayer.Builder,
DataBuilder<BannerPatternLayer> {
    private DyeColor color;
    private BannerPatternShape shape;

    public SpongePatternLayerBuilder() {
        super(BannerPatternLayer.class, 1);
    }

    @Override
    protected Optional<BannerPatternLayer> buildContent(DataView container) throws InvalidDataException {
        Objects.requireNonNull(container);
        if (!container.contains(Constants.TileEntity.Banner.SHAPE) || !container.contains(Constants.TileEntity.Banner.COLOR)) {
            return Optional.empty();
        }
        BannerPatternShape shape = container.getRegistryValue(Constants.TileEntity.Banner.SHAPE, RegistryTypes.BANNER_PATTERN_SHAPE, Sponge.game()).orElseThrow(() -> new InvalidDataException("The provided container has an invalid banner pattern shape entry!"));
        DyeColor color = container.getRegistryValue(Constants.TileEntity.Banner.COLOR, RegistryTypes.DYE_COLOR, Sponge.game()).orElseThrow(() -> new InvalidDataException("The provided container has an invalid dye color entry!"));
        return Optional.of(new SpongePatternLayer(shape, color));
    }

    @Override
    public SpongePatternLayerBuilder reset() {
        this.shape = null;
        this.color = null;
        return this;
    }

    @Override
    public BannerPatternLayer.Builder pattern(BannerPatternShape shape) {
        this.shape = Objects.requireNonNull(shape);
        return this;
    }

    @Override
    public BannerPatternLayer.Builder color(DyeColor color) {
        this.color = Objects.requireNonNull(color);
        return this;
    }

    @Override
    public BannerPatternLayer.Builder from(BannerPatternLayer value) {
        this.shape = value.shape();
        this.color = value.color();
        return this;
    }

    @Override
    public BannerPatternLayer build() {
        Preconditions.checkState(this.shape != null);
        Preconditions.checkState(this.color != null);
        return new SpongePatternLayer(this.shape, this.color);
    }
}

