/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.block.entity;

import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.animal.Pig;
import org.spongepowered.api.util.weighted.TableEntry;
import org.spongepowered.api.util.weighted.WeightedObject;
import org.spongepowered.api.util.weighted.WeightedSerializableObject;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.world.level.BaseSpawnerAccessor;
import org.spongepowered.common.accessor.world.level.block.entity.SpawnerBlockEntityAccessor;
import org.spongepowered.common.bridge.world.level.BaseSpawnerBridge;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.entity.SpongeEntityArchetypeBuilder;
import org.spongepowered.common.util.SpongeTicks;

public final class MobSpawnerData {
    private MobSpawnerData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(SpawnerBlockEntityAccessor.class).create(Keys.MAX_NEARBY_ENTITIES).get(h -> ((BaseSpawnerAccessor)h.accessor$spawner()).accessor$maxNearbyEntities())).set((h, v) -> ((BaseSpawnerAccessor)h.accessor$spawner()).accessor$maxNearbyEntities((int)v))).create(Keys.MAX_SPAWN_DELAY).get(h -> new SpongeTicks(((BaseSpawnerAccessor)h.accessor$spawner()).accessor$maxSpawnDelay()))).setAnd((h, v) -> {
            if (v.isInfinite()) {
                return false;
            }
            ((BaseSpawnerAccessor)h.accessor$spawner()).accessor$maxSpawnDelay(SpongeTicks.toSaturatedIntOrInfinite(v));
            return true;
        })).create(Keys.MIN_SPAWN_DELAY).get(h -> new SpongeTicks(((BaseSpawnerAccessor)h.accessor$spawner()).accessor$minSpawnDelay()))).setAnd((h, v) -> {
            if (v.isInfinite()) {
                return false;
            }
            ((BaseSpawnerAccessor)h.accessor$spawner()).accessor$minSpawnDelay(SpongeTicks.toSaturatedIntOrInfinite(v));
            return true;
        })).create(Keys.NEXT_ENTITY_TO_SPAWN).get(h -> MobSpawnerData.getNextEntity((BaseSpawnerAccessor)h.accessor$spawner()))).set((h, v) -> MobSpawnerData.setNextEntity((SpawnerBlockEntity)h, v))).create(Keys.REMAINING_SPAWN_DELAY).get(h -> new SpongeTicks(((BaseSpawnerAccessor)h.accessor$spawner()).accessor$spawnDelay()))).setAnd((h, v) -> {
            if (v.isInfinite()) {
                return false;
            }
            ((BaseSpawnerAccessor)h.accessor$spawner()).accessor$spawnDelay(SpongeTicks.toSaturatedIntOrInfinite(v));
            return true;
        })).create(Keys.REQUIRED_PLAYER_RANGE).get(h -> ((BaseSpawnerAccessor)h.accessor$spawner()).accessor$requiredPlayerRange())).set((h, v) -> ((BaseSpawnerAccessor)h.accessor$spawner()).accessor$requiredPlayerRange(v.intValue()))).create(Keys.SPAWN_COUNT).get(h -> ((BaseSpawnerAccessor)h.accessor$spawner()).accessor$spawnCount())).set((h, v) -> ((BaseSpawnerAccessor)h.accessor$spawner()).accessor$spawnCount((int)v))).create(Keys.SPAWN_RANGE).get(h -> ((BaseSpawnerAccessor)h.accessor$spawner()).accessor$spawnRange())).set((h, v) -> ((BaseSpawnerAccessor)h.accessor$spawner()).accessor$spawnRange(v.intValue()))).create(Keys.SPAWNABLE_ENTITIES).get(h -> MobSpawnerData.getEntities(h.accessor$spawner()))).set((h, v) -> {
            BaseSpawnerAccessor logic = (BaseSpawnerAccessor)h.accessor$spawner();
            MobSpawnerData.setEntities(logic, v);
            MobSpawnerData.setNextEntity((SpawnerBlockEntity)h, MobSpawnerData.getNextEntity(logic));
        });
    }

    private static WeightedSerializableObject<EntityArchetype> getNextEntity(BaseSpawnerAccessor logic) {
        boolean weight = true;
        String resourceLocation = logic.accessor$nextSpawnData().entityToSpawn().getString("id");
        Registry entityTypeRegistry = SpongeCommon.vanillaRegistry(Registries.ENTITY_TYPE);
        EntityType<Pig> type = entityTypeRegistry.getOptional(new ResourceLocation(resourceLocation)).map(EntityType.class::cast).orElse(EntityTypes.PIG.get());
        CompoundTag data = logic.accessor$nextSpawnData().entityToSpawn();
        EntityArchetype archetype = SpongeEntityArchetypeBuilder.pooled().type(type).entityData(NBTTranslator.INSTANCE.translateFrom(data)).build();
        return new WeightedSerializableObject<EntityArchetype>(archetype, 1);
    }

    private static void setNextEntity(SpawnerBlockEntity entity, WeightedSerializableObject<EntityArchetype> value) {
        CompoundTag compound = NBTTranslator.INSTANCE.translate(((EntityArchetype)value.get()).entityData());
        if (!compound.contains("id")) {
            ResourceKey key = (ResourceKey)net.minecraft.world.entity.EntityType.getKey((net.minecraft.world.entity.EntityType)((net.minecraft.world.entity.EntityType)((EntityArchetype)value.get()).type()));
            compound.putString("id", key.toString());
        }
        ((BaseSpawnerBridge)entity.getSpawner()).bridge$setNextSpawnData(entity.getLevel(), entity.getBlockPos(), new SpawnData(compound, Optional.empty()));
    }

    private static WeightedTable<EntityArchetype> getEntities(BaseSpawner logic) {
        WeightedTable<EntityArchetype> possibleEntities = new WeightedTable<EntityArchetype>();
        for (WeightedEntry.Wrapper weightedEntity : ((BaseSpawnerAccessor)logic).accessor$spawnPotentials().unwrap()) {
            CompoundTag nbt = ((SpawnData)weightedEntity.getData()).entityToSpawn();
            String resourceLocation = nbt.getString("id");
            Registry entityTypeRegistry = SpongeCommon.vanillaRegistry(Registries.ENTITY_TYPE);
            EntityType<Pig> type = entityTypeRegistry.getOptional(new ResourceLocation(resourceLocation)).map(EntityType.class::cast).orElse(EntityTypes.PIG.get());
            EntityArchetype archetype = SpongeEntityArchetypeBuilder.pooled().type(type).entityData(NBTTranslator.INSTANCE.translateFrom(nbt)).build();
            possibleEntities.add((TableEntry<EntityArchetype>)new WeightedSerializableObject<EntityArchetype>(archetype, weightedEntity.getWeight().asInt()));
        }
        return possibleEntities;
    }

    private static void setEntities(BaseSpawnerAccessor logic, WeightedTable<EntityArchetype> table) {
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.builder();
        for (TableEntry<EntityArchetype> tableEntry : table) {
            if (!(tableEntry instanceof WeightedObject)) continue;
            WeightedObject object = (WeightedObject)tableEntry;
            CompoundTag compound = NBTTranslator.INSTANCE.translate(((EntityArchetype)object.get()).entityData());
            if (!compound.contains("id")) {
                ResourceKey key = (ResourceKey)net.minecraft.world.entity.EntityType.getKey((net.minecraft.world.entity.EntityType)((net.minecraft.world.entity.EntityType)((EntityArchetype)object.get()).type()));
                compound.putString("id", key.toString());
            }
            builder.add((Object)new SpawnData(compound, Optional.empty()), (int)tableEntry.weight());
        }
        logic.accessor$spawnPotentials((SimpleWeightedRandomList<SpawnData>)builder.build());
    }
}

