/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.entity;

import com.google.common.collect.ImmutableList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.api.data.Keys;
import org.spongepowered.common.accessor.world.entity.EntityAccessor;
import org.spongepowered.common.accessor.world.entity.projectile.FireworkRocketEntityAccessor;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.util.FireworkUtil;
import org.spongepowered.common.util.SpongeTicks;

public final class FireworkRocketData {
    private FireworkRocketData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(FireworkRocketEntity.class).create(Keys.FIREWORK_EFFECTS).get(h -> FireworkUtil.getFireworkEffects(h).orElse(null))).set(FireworkUtil::setFireworkEffects)).resetOnDelete(ImmutableList.of())).create(Keys.FIREWORK_FLIGHT_MODIFIER).get(h -> {
            ItemStack item = FireworkUtil.getItem(h);
            CompoundTag fireworks = item.getOrCreateTagElement("Fireworks");
            if (fireworks.contains("Flight")) {
                return new SpongeTicks(fireworks.getByte("Flight"));
            }
            return null;
        })).setAnd((h, v) -> {
            int ticks = SpongeTicks.toSaturatedIntOrInfinite(v);
            if (v.isInfinite() || ticks < 0 || ticks > 127) {
                return false;
            }
            ItemStack item = FireworkUtil.getItem(h);
            CompoundTag fireworks = item.getOrCreateTagElement("Fireworks");
            fireworks.putByte("Flight", (byte)ticks);
            ((FireworkRocketEntityAccessor)h).accessor$lifetime(10 * ticks + ((EntityAccessor)h).accessor$random().nextInt(6) + ((EntityAccessor)h).accessor$random().nextInt(7));
            return true;
        });
    }
}

