/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.item.stack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.item.enchantment.EnchantmentType;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.item.enchantment.SpongeEnchantment;
import org.spongepowered.common.util.NBTCollectors;
import org.spongepowered.common.util.NBTStreams;
import org.spongepowered.common.util.Predicates;

public final class BookPagesItemStackData {
    private static final String NBTKeyAppliedEnchantments = "Enchantments";
    private static final String NBTKeyStoredEnchantments = "StoredEnchantments";

    private BookPagesItemStackData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(ItemStack.class).create(Keys.APPLIED_ENCHANTMENTS).get(h -> BookPagesItemStackData.get(h, NBTKeyAppliedEnchantments))).set((h, v) -> BookPagesItemStackData.set(h, v, iv -> iv.stream().filter(Predicates.distinctBy(org.spongepowered.api.item.enchantment.Enchantment::type)), NBTKeyAppliedEnchantments))).delete(h -> BookPagesItemStackData.delete(h, NBTKeyAppliedEnchantments))).create(Keys.STORED_ENCHANTMENTS).get(h -> BookPagesItemStackData.get(h, NBTKeyStoredEnchantments))).set((h, v) -> BookPagesItemStackData.set(h, v, Collection::stream, NBTKeyStoredEnchantments))).delete(h -> BookPagesItemStackData.delete(h, NBTKeyStoredEnchantments))).supports(h -> h.getItem() == Items.ENCHANTED_BOOK);
    }

    private static List<org.spongepowered.api.item.enchantment.Enchantment> get(ItemStack holder, String nbtKey) {
        CompoundTag tag = holder.getTag();
        if (tag == null || !tag.contains(nbtKey, 9)) {
            return new ArrayList<org.spongepowered.api.item.enchantment.Enchantment>();
        }
        ListTag list = tag.getList(nbtKey, 10);
        return NBTStreams.toCompounds((Iterable<Tag>)list).map(BookPagesItemStackData::enchantmentFromNbt).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static boolean set(ItemStack holder, List<org.spongepowered.api.item.enchantment.Enchantment> value, Function<List<org.spongepowered.api.item.enchantment.Enchantment>, Stream<org.spongepowered.api.item.enchantment.Enchantment>> filter, String nbtKey) {
        if (value.isEmpty()) {
            return BookPagesItemStackData.delete(holder, nbtKey);
        }
        CompoundTag tag = holder.getOrCreateTag();
        ListTag list = filter.apply(value).map(BookPagesItemStackData::enchantmentToNbt).collect(NBTCollectors.toTagList());
        tag.put(nbtKey, (Tag)list);
        return true;
    }

    private static boolean delete(ItemStack holder, String nbtKey) {
        CompoundTag tag = holder.getTag();
        if (tag != null) {
            tag.remove(nbtKey);
        }
        return true;
    }

    private static org.spongepowered.api.item.enchantment.Enchantment enchantmentFromNbt(CompoundTag compound) {
        String enchantmentId = compound.getString("id");
        int level = compound.getInt("lvl");
        Registry enchantmentRegistry = SpongeCommon.vanillaRegistry(Registries.ENCHANTMENT);
        EnchantmentType enchantment = enchantmentRegistry.getOptional(ResourceLocation.tryParse((String)enchantmentId)).orElse(null);
        return enchantment == null ? null : new SpongeEnchantment(enchantment, level);
    }

    private static CompoundTag enchantmentToNbt(org.spongepowered.api.item.enchantment.Enchantment enchantment) {
        CompoundTag compound = new CompoundTag();
        Registry enchantmentRegistry = SpongeCommon.vanillaRegistry(Registries.ENCHANTMENT);
        String enchantmentId = String.valueOf(enchantmentRegistry.getKey((Object)((Enchantment)enchantment.type())));
        compound.putString("id", enchantmentId);
        compound.putShort("lvl", (short)((byte)enchantment.level()));
        return compound;
    }
}

