/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.ai;

import java.util.Objects;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import org.spongepowered.api.entity.ai.goal.builtin.LookAtGoal;
import org.spongepowered.api.entity.living.Agent;
import org.spongepowered.api.entity.living.Living;

public final class SpongeWatchClosestAIBuilder
implements LookAtGoal.Builder {
    private Class<? extends Living> watchedClass;
    private float maxDistance;
    private float chance;

    public SpongeWatchClosestAIBuilder() {
        this.reset();
    }

    @Override
    public LookAtGoal.Builder watch(Class<? extends Living> watchedClass) {
        this.watchedClass = watchedClass;
        return this;
    }

    @Override
    public LookAtGoal.Builder maxDistance(float maxDistance) {
        this.maxDistance = maxDistance;
        return this;
    }

    @Override
    public LookAtGoal.Builder chance(float chance) {
        this.chance = chance;
        return this;
    }

    @Override
    public LookAtGoal.Builder from(LookAtGoal value) {
        return this.watch(value.watchedClass()).maxDistance(value.maxDistance()).chance(value.chance());
    }

    @Override
    public LookAtGoal.Builder reset() {
        this.watchedClass = null;
        this.maxDistance = 8.0f;
        this.chance = 0.02f;
        return this;
    }

    @Override
    public LookAtGoal build(Agent owner) {
        Objects.requireNonNull(this.watchedClass);
        return (LookAtGoal)new LookAtPlayerGoal((Mob)owner, this.watchedClass, this.maxDistance, this.chance);
    }
}

