/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.ai.goal.builtin;

import java.util.Objects;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import org.spongepowered.api.entity.ai.goal.builtin.SwimGoal;
import org.spongepowered.api.entity.living.Agent;

public final class SpongeSwimGoalBuilder
implements SwimGoal.Builder {
    private float chance;

    public SpongeSwimGoalBuilder() {
        this.reset();
    }

    @Override
    public SwimGoal.Builder swimChance(float chance) {
        this.chance = chance;
        return this;
    }

    @Override
    public SwimGoal.Builder from(SwimGoal value) {
        Objects.requireNonNull(value);
        return this.swimChance(value.swimChance());
    }

    @Override
    public SwimGoal.Builder reset() {
        this.chance = 0.8f;
        return this;
    }

    @Override
    public SwimGoal build(Agent owner) {
        Objects.requireNonNull(owner);
        SwimGoal task = (SwimGoal)new FloatGoal((Mob)owner);
        task.setSwimChance(this.chance);
        return task;
    }
}

