/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.ai.goal.builtin.creature;

import java.util.Objects;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import org.spongepowered.api.entity.ai.goal.builtin.creature.RandomWalkingGoal;
import org.spongepowered.api.entity.living.Creature;

public final class SpongeRandomWalkingGoalBuilder
implements RandomWalkingGoal.Builder {
    private double speed;
    private int executionChance;

    public SpongeRandomWalkingGoalBuilder() {
        this.reset();
    }

    @Override
    public RandomWalkingGoal.Builder speed(double speed) {
        this.speed = speed;
        return this;
    }

    @Override
    public RandomWalkingGoal.Builder executionChance(int executionChance) {
        this.executionChance = executionChance;
        return this;
    }

    @Override
    public RandomWalkingGoal.Builder from(RandomWalkingGoal value) {
        return this.speed(value.speed()).executionChance(value.executionChance());
    }

    @Override
    public RandomWalkingGoal.Builder reset() {
        this.speed = 1.0;
        this.executionChance = 120;
        return this;
    }

    @Override
    public RandomWalkingGoal build(Creature owner) {
        Objects.requireNonNull(owner);
        return (RandomWalkingGoal)new RandomStrollGoal((PathfinderMob)owner, this.speed, this.executionChance);
    }
}

