/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.living.human;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.ProfileResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.profile.property.ProfileProperty;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.scoreboard.TeamMember;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.network.protocol.game.ClientboundAddEntityPacketAccessor;
import org.spongepowered.common.accessor.network.protocol.game.ClientboundPlayerInfoUpdatePacketAccessor;
import org.spongepowered.common.accessor.world.entity.LivingEntityAccessor;
import org.spongepowered.common.accessor.world.entity.player.PlayerAccessor;
import org.spongepowered.common.config.SpongeGameConfigs;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.profile.SpongeProfileProperty;
import org.spongepowered.common.util.SpongeTicks;

public final class HumanEntity
extends PathfinderMob
implements TeamMember,
RangedAttackMob {
    public static final ResourceKey<EntityType<?>> KEY = ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)new ResourceLocation("sponge", "human"));
    private final Map<UUID, List<Stream<Packet<?>>>> playerPacketMap = new HashMap();
    private GameProfile fakeProfile = new GameProfile(this.uuid, "");
    private boolean aiDisabled = false;
    private boolean leftHanded = false;

    public static AttributeSupplier createAttributes() {
        return Mob.createMobAttributes().add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.23f).add(Attributes.ATTACK_SPEED).add(Attributes.LUCK).build();
    }

    public HumanEntity(EntityType<? extends HumanEntity> type, Level world) {
        super(type, world);
        this.setCanPickUpLoot(true);
        this.entityData.set(PlayerAccessor.accessor$DATA_PLAYER_MODE_CUSTOMISATION(), (Object)127);
    }

    protected void defineSynchedData() {
        this.entityData.define(LivingEntityAccessor.accessor$DATA_LIVING_ENTITY_FLAGS(), (Object)0);
        this.entityData.define(LivingEntityAccessor.accessor$DATA_HEALTH_ID(), (Object)Float.valueOf(1.0f));
        this.entityData.define(LivingEntityAccessor.accessor$DATA_EFFECT_COLOR_ID(), (Object)0);
        this.entityData.define(LivingEntityAccessor.accessor$DATA_EFFECT_AMBIENCE_ID(), (Object)Boolean.FALSE);
        this.entityData.define(LivingEntityAccessor.accessor$DATA_ARROW_COUNT_ID(), (Object)0);
        this.entityData.define(LivingEntityAccessor.accessor$DATA_STINGER_COUNT_ID(), (Object)0);
        this.entityData.define(LivingEntityAccessor.accessor$SLEEPING_POS_ID(), Optional.empty());
        this.entityData.define(PlayerAccessor.accessor$DATA_PLAYER_ABSORPTION_ID(), (Object)Float.valueOf(0.0f));
        this.entityData.define(PlayerAccessor.accessor$DATA_SCORE_ID(), (Object)0);
        this.entityData.define(PlayerAccessor.accessor$DATA_PLAYER_MODE_CUSTOMISATION(), (Object)0);
        this.entityData.define(PlayerAccessor.accessor$DATA_PLAYER_MAIN_HAND(), (Object)1);
        this.entityData.define(PlayerAccessor.accessor$DATA_SHOULDER_LEFT(), (Object)new CompoundTag());
        this.entityData.define(PlayerAccessor.accessor$DATA_SHOULDER_RIGHT(), (Object)new CompoundTag());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public boolean isLeftHanded() {
        return this.leftHanded;
    }

    public boolean isNoAi() {
        return this.aiDisabled;
    }

    @Override
    public Component teamRepresentation() {
        return Component.text((String)this.fakeProfile.getName());
    }

    public PlayerTeam getTeam() {
        return this.level().getScoreboard().getPlayersTeam(this.fakeProfile.getName());
    }

    public void setCustomName(@Nullable net.minecraft.network.chat.Component name) {
        net.minecraft.network.chat.Component customName = this.getCustomName();
        if (customName == null && name == null || customName != null && customName.equals(name)) {
            return;
        }
        super.setCustomName(name);
        this.setProfileName(name);
        if (this.isAliveAndInWorld()) {
            this.respawnOnClient();
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("profile")) {
            this.fakeProfile = NbtUtils.readGameProfile((CompoundTag)tag.getCompound("profile"));
            this.setUUID(this.fakeProfile.getId());
            if (this.fakeProfile.getName() == null) {
                this.fakeProfile = new GameProfile(this.fakeProfile.getId(), "");
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("profile", (Tag)NbtUtils.writeGameProfile((CompoundTag)new CompoundTag(), (GameProfile)this.fakeProfile));
    }

    public void aiStep() {
        super.aiStep();
        this.updateSwingTime();
    }

    public void setNoAi(boolean disable) {
        this.aiDisabled = disable;
    }

    public void setLeftHanded(boolean leftHanded) {
        this.leftHanded = leftHanded;
    }

    public void setAggressive(boolean aggressive) {
    }

    public int getPortalWaitTime() {
        return 1;
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.PLAYER_SWIM;
    }

    protected SoundEvent getSwimSplashSound() {
        return SoundEvents.PLAYER_SPLASH;
    }

    public int getDimensionChangingDelay() {
        return 10;
    }

    public void die(@Nullable DamageSource cause) {
        super.die(cause);
        this.reapplyPosition();
        if (cause != null) {
            this.setDeltaMovement(-Mth.cos((float)((this.getHurtDir() + this.getYRot()) * ((float)Math.PI / 180))) * 0.1f, 0.1f, -Mth.sin((float)((this.getHurtDir() + this.getYRot()) * ((float)Math.PI / 180))) * 0.1f);
        } else {
            this.setDeltaMovement(0.0, 0.1, 0.0);
        }
        this.clearFire();
        this.setSharedFlag(0, false);
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.PLAYER_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.PLAYER_DEATH;
    }

    protected float ridingOffset(Entity $$0) {
        return -0.35f;
    }

    public float getSpeed() {
        return (float)this.getAttribute(Attributes.MOVEMENT_SPEED).getValue();
    }

    public LivingEntity.Fallsounds getFallSounds() {
        return new LivingEntity.Fallsounds(SoundEvents.PLAYER_SMALL_FALL, SoundEvents.PLAYER_BIG_FALL);
    }

    public float getAbsorptionAmount() {
        return ((Float)this.getEntityData().get(PlayerAccessor.accessor$DATA_PLAYER_ABSORPTION_ID())).floatValue();
    }

    public void internalSetAbsorptionAmount(float amount) {
        this.getEntityData().set(PlayerAccessor.accessor$DATA_PLAYER_ABSORPTION_ID(), (Object)Float.valueOf(amount));
    }

    protected float tickHeadTurn(float p_110146_1_, float p_110146_2_) {
        float retValue = super.tickHeadTurn(p_110146_1_, p_110146_2_);
        this.setYRot(this.getYHeadRot());
        return retValue;
    }

    public boolean doHurtTarget(Entity entityIn) {
        super.doHurtTarget(entityIn);
        this.swing(this.getUsedItemHand());
        float f = (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getValue();
        int i = 0;
        i += EnchantmentHelper.getKnockbackBonus((LivingEntity)this);
        boolean flag = entityIn.hurt(this.damageSources().mobAttack((LivingEntity)this), f += EnchantmentHelper.getDamageBonus((ItemStack)this.getItemInHand(InteractionHand.MAIN_HAND), (MobType)this.getMobType()));
        if (flag) {
            int j;
            if (i > 0) {
                entityIn.push((double)(-Mth.sin((float)(this.getYRot() * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(Mth.cos((float)(this.getYRot() * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
            }
            if ((j = EnchantmentHelper.getFireAspect((LivingEntity)this)) > 0) {
                entityIn.setSecondsOnFire(j * 4);
            }
            this.doEnchantDamageEffects((LivingEntity)this, entityIn);
        }
        return flag;
    }

    private void setProfileName(@Nullable net.minecraft.network.chat.Component newName) {
        PropertyMap props = this.fakeProfile.getProperties();
        this.fakeProfile = new GameProfile(this.fakeProfile.getId(), newName == null ? "" : newName.getString());
        this.fakeProfile.getProperties().putAll((Multimap)props);
    }

    public boolean getOrLoadSkin(UUID minecraftAccount) {
        GameProfile gameProfile = SpongeCommon.server().getProfileCache().get(minecraftAccount).orElse(null);
        if (gameProfile == null) {
            ProfileResult result = SpongeCommon.server().getSessionService().fetchProfile(minecraftAccount, true);
            if (result == null) {
                return false;
            }
            gameProfile = result.profile();
            SpongeCommon.server().getProfileCache().add(gameProfile);
        }
        this.fakeProfile.getProperties().replaceValues((Object)"textures", (Iterable)gameProfile.getProperties().get((Object)"textures"));
        if (this.isAliveAndInWorld()) {
            this.respawnOnClient();
        }
        return true;
    }

    public boolean getOrLoadSkin(String minecraftAccount) {
        Objects.requireNonNull(minecraftAccount);
        GameProfile gameProfile = SpongeCommon.server().getProfileCache().get(minecraftAccount).orElse(null);
        if (gameProfile == null) {
            return false;
        }
        if (gameProfile.getProperties().isEmpty()) {
            ProfileResult result = SpongeCommon.server().getSessionService().fetchProfile(gameProfile.getId(), true);
            if (result == null) {
                return false;
            }
            gameProfile = result.profile();
            SpongeCommon.server().getProfileCache().add(gameProfile);
        }
        this.fakeProfile.getProperties().clear();
        this.fakeProfile.getProperties().putAll((Multimap)gameProfile.getProperties());
        if (this.isAliveAndInWorld()) {
            this.respawnOnClient();
        }
        return true;
    }

    public void removeFromTabListDelayed(@Nullable ServerPlayer player, ClientboundPlayerInfoRemovePacket removePacket) {
        int delay = ((WorldConfig)SpongeGameConfigs.getForWorld((Level)this.level()).get()).entity.human.tabListRemoveDelay;
        Runnable removeTask = () -> this.pushPackets(player, new Packet[]{removePacket});
        if (delay == 0) {
            removeTask.run();
        } else {
            Sponge.server().scheduler().submit(Task.builder().execute(removeTask).delay(new SpongeTicks(delay)).plugin(((Launch)Launch.instance()).commonPlugin()).build());
        }
    }

    public SpongeProfileProperty getSkinProperty() {
        Collection properties = this.fakeProfile.getProperties().get((Object)"textures");
        if (properties.isEmpty()) {
            return null;
        }
        return new SpongeProfileProperty((Property)properties.iterator().next());
    }

    public void setSkinProperty(ProfileProperty property) {
        this.fakeProfile.getProperties().replaceValues((Object)"textures", Collections.singletonList(((SpongeProfileProperty)property).asProperty()));
        if (this.isAliveAndInWorld()) {
            this.respawnOnClient();
        }
    }

    private boolean isAliveAndInWorld() {
        return this.level().getEntity(this.getId()) == this && !this.isRemoved();
    }

    private void respawnOnClient() {
        this.pushPackets(new Packet[]{new ClientboundRemoveEntitiesPacket(new int[]{this.getId()}), this.createPlayerListPacket(EnumSet.allOf(ClientboundPlayerInfoUpdatePacket.Action.class))});
        this.pushPackets(this.getAddEntityPacket());
    }

    public boolean canRemoveFromListImmediately() {
        return !this.fakeProfile.getProperties().containsKey((Object)"textures");
    }

    public void untrackFrom(ServerPlayer player) {
        this.playerPacketMap.remove(player.getUUID());
        player.connection.send((Packet)new ClientboundPlayerInfoRemovePacket(List.of(this.uuid)));
    }

    public ClientboundPlayerInfoUpdatePacket createPlayerListPacket(EnumSet<ClientboundPlayerInfoUpdatePacket.Action> actions) {
        ClientboundPlayerInfoUpdatePacket packet = new ClientboundPlayerInfoUpdatePacket(actions, List.of());
        ((ClientboundPlayerInfoUpdatePacketAccessor)packet).accessor$entries(List.of(new ClientboundPlayerInfoUpdatePacket.Entry(this.uuid, this.fakeProfile, false, 0, GameType.DEFAULT_MODE, this.getDisplayName(), null)));
        return packet;
    }

    public void pushPackets(Packet<?> ... packets) {
        this.pushPackets((ServerPlayer)null, packets);
    }

    public void pushPackets(@Nullable ServerPlayer player, Packet<?> ... packets) {
        List queue = player == null ? this.playerPacketMap.computeIfAbsent(null, k -> new ArrayList()) : this.playerPacketMap.computeIfAbsent(player.getUUID(), k -> new ArrayList());
        queue.add(Stream.of(packets));
    }

    public Stream<Packet<?>> popQueuedPackets(@Nullable ServerPlayer player) {
        List<Stream<Packet<?>>> queue = this.playerPacketMap.get(player == null ? null : player.getUUID());
        return queue == null || queue.isEmpty() ? Stream.empty() : queue.remove(0);
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        ItemStack itemstack;
        Arrow entitytippedarrow = new Arrow(this.level(), (LivingEntity)this, new ItemStack((ItemLike)Items.ARROW));
        double d0 = target.getX() - this.getX();
        double d1 = target.getBoundingBox().minY + (double)(target.getBbHeight() / 3.0f) - entitytippedarrow.getY();
        double d2 = target.getZ() - this.getZ();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        entitytippedarrow.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
        int i = EnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantments.PUNCH_ARROWS, (LivingEntity)this);
        int j = EnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantments.FLAMING_ARROWS, (LivingEntity)this);
        entitytippedarrow.setBaseDamage((double)(distanceFactor * 2.0f) + this.random.nextGaussian() * 0.25 + (double)((float)this.level().getDifficulty().getId() * 0.11f));
        if (i > 0) {
            entitytippedarrow.setBaseDamage(entitytippedarrow.getBaseDamage() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            entitytippedarrow.setKnockback(j);
        }
        if ((itemstack = this.getItemInHand(InteractionHand.OFF_HAND)).getItem() == Items.TIPPED_ARROW) {
            entitytippedarrow.setEffectsFromItem(itemstack);
        }
        this.playSound(SoundEvents.ARROW_SHOOT, 1.0f, 1.0f / (this.random.nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)entitytippedarrow);
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        ClientboundAddEntityPacket packet = new ClientboundAddEntityPacket((Entity)this);
        ((ClientboundAddEntityPacketAccessor)packet).accessor$type(EntityType.PLAYER);
        return packet;
    }
}

