/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.player.tab;

import java.util.Objects;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.tab.TabList;
import org.spongepowered.api.entity.living.player.tab.TabListEntry;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.common.entity.player.tab.SpongeTabListEntry;
import org.spongepowered.common.util.Preconditions;

public final class TabListEntryBuilder
implements TabListEntry.Builder {
    private @Nullable TabList list;
    private @Nullable GameProfile profile;
    private @Nullable Component displayName;
    private int latency;
    private boolean listed = true;
    private @Nullable GameMode gameMode;

    @Override
    public TabListEntry.Builder list(TabList list) {
        this.list = Objects.requireNonNull(list, "list");
        return this;
    }

    @Override
    public TabListEntry.Builder profile(GameProfile profile) {
        this.profile = Objects.requireNonNull(profile, "profile");
        return this;
    }

    @Override
    public TabListEntry.Builder displayName(@Nullable Component displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    public TabListEntry.Builder latency(int latency) {
        this.latency = latency;
        return this;
    }

    @Override
    public TabListEntry.Builder gameMode(GameMode gameMode) {
        this.gameMode = Objects.requireNonNull(gameMode, "game mode");
        return this;
    }

    @Override
    public TabListEntry.Builder listed(boolean listed) {
        this.listed = listed;
        return this;
    }

    @Override
    public TabListEntry build() {
        Preconditions.checkState(this.list != null, "list must be set");
        Preconditions.checkState(this.profile != null, "profile must be set");
        Preconditions.checkState(this.gameMode != null, "game mode must be set");
        return new SpongeTabListEntry(this.list, this.profile, this.displayName, this.latency, this.gameMode, this.listed, null);
    }

    @Override
    public TabListEntry.Builder from(TabListEntry value) {
        this.list = Objects.requireNonNull(value.list(), "list");
        this.profile = Objects.requireNonNull(value.profile(), "profile");
        this.displayName = value.displayName().orElse(null);
        this.latency = value.latency();
        this.gameMode = Objects.requireNonNull(value.gameMode(), "game mode");
        return this;
    }

    @Override
    public TabListEntry.Builder reset() {
        this.list = null;
        this.profile = null;
        this.displayName = null;
        this.latency = 0;
        this.gameMode = null;
        return this;
    }
}

