/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.cause.entity.damage;

import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.damagesource.DamageSource;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.cause.entity.damage.DamageType;
import org.spongepowered.api.event.cause.entity.damage.source.DamageSource;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.damagesource.DamageSourceBridge;
import org.spongepowered.common.util.Preconditions;

public class SpongeDamageSourceBuilder
implements DamageSource.Builder {
    private Holder<net.minecraft.world.damagesource.DamageType> damageType;
    private net.minecraft.world.entity.Entity directEntity;
    private net.minecraft.world.entity.Entity causingEntity;
    private ServerLocation location;
    private BlockSnapshot blockSnapshot;

    @Override
    public org.spongepowered.api.event.cause.entity.damage.source.DamageSource build() throws IllegalStateException {
        Preconditions.checkState(this.damageType != null, "DamageType was null!");
        if (this.location != null) {
            Preconditions.checkState(this.blockSnapshot != null, "BlockSnapshot is null");
        }
        if (this.blockSnapshot != null) {
            Preconditions.checkState(this.location != null, "ServerLocation is null");
        }
        DamageSource source = new DamageSource(this.damageType, this.directEntity, this.causingEntity);
        ((DamageSourceBridge)source).bridge$setBlock(this.location, this.blockSnapshot);
        return (org.spongepowered.api.event.cause.entity.damage.source.DamageSource)source;
    }

    @Override
    public DamageSource.Builder type(DamageType damageType) {
        Registry registry = SpongeCommon.server().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE);
        this.damageType = registry.wrapAsHolder((Object)((net.minecraft.world.damagesource.DamageType)damageType));
        return this;
    }

    @Override
    public SpongeDamageSourceBuilder entity(Entity entity) {
        this.directEntity = (net.minecraft.world.entity.Entity)entity;
        return this;
    }

    @Override
    public SpongeDamageSourceBuilder indirectEntity(Entity proxy) {
        this.causingEntity = (net.minecraft.world.entity.Entity)proxy;
        return this;
    }

    @Override
    public DamageSource.Builder block(ServerLocation location) {
        this.location = location;
        return this;
    }

    @Override
    public DamageSource.Builder block(BlockSnapshot blockSnapshot) {
        this.blockSnapshot = blockSnapshot;
        return this;
    }

    @Override
    public SpongeDamageSourceBuilder from(org.spongepowered.api.event.cause.entity.damage.source.DamageSource value) {
        this.type(value.type());
        value.source().ifPresent(this::entity);
        value.indirectSource().ifPresent(this::indirectEntity);
        value.blockSnapshot().ifPresent(this::block);
        value.location().ifPresent(this::block);
        return this;
    }
}

