/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhasePrinter;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.UnwindingPhaseContext;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;

public final class UnwindingState
implements IPhaseState<UnwindingPhaseContext> {
    private final String desc = TrackingUtil.phaseStateToString("General", this);

    public static UnwindingState getInstance() {
        return Holder.INSTANCE;
    }

    private UnwindingState() {
    }

    @Override
    public UnwindingPhaseContext createPhaseContext(PhaseTracker server) {
        throw new UnsupportedOperationException("Use UnwindingPhaseContext#unwind(IPhaseState, PhaseContext)! Cannot create a context based on Post state!");
    }

    @Override
    public boolean requiresPost() {
        return false;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void appendContextPreExplosion(ExplosionContext explosionContext, UnwindingPhaseContext context) {
        @NonNull T unwinding = context.getUnwindingContext();
        unwinding.appendContextPreExplosion(explosionContext);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void associateNeighborStateNotifier(UnwindingPhaseContext context, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, ServerLevel minecraftWorld, PlayerTracker.Type notifier) {
        @NonNull T unwindingContext = context.getUnwindingContext();
        unwindingContext.associateNeighborStateNotifier(sourcePos, block, notifyPos, minecraftWorld, notifier);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void unwind(UnwindingPhaseContext context) {
        @NonNull T unwindingContext = context.getUnwindingContext();
        try {
            if (!((PhaseContext)unwindingContext).getTransactor().isEmpty()) {
                PhasePrinter.printUnprocessedPhaseContextObjects(context.createdTracker.stack, this, context);
            }
        }
        catch (Exception e) {
            PhasePrinter.printExceptionFromPhase(PhaseTracker.getInstance().stack, e, context);
        }
    }

    @Override
    public Supplier<ResourceKey> attemptWorldKey(UnwindingPhaseContext context) {
        Optional<Supplier> o = context.getSource(Entity.class).map(s -> () -> (ResourceKey)s.level().dimension().location());
        return o.orElseThrow(() -> new IllegalStateException("Expected to be ticking an entity!"));
    }

    public String toString() {
        return this.desc;
    }

    private static final class Holder {
        static final UnwindingState INSTANCE = new UnwindingState();

        private Holder() {
        }
    }
}

