/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.effect;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class SpawnDestructBlocksEffect
implements ProcessingSideEffect {
    public static SpawnDestructBlocksEffect getInstance() {
        return Holder.INSTANCE;
    }

    SpawnDestructBlocksEffect() {
    }

    @Override
    public EffectResult processSideEffect(BlockPipeline pipeline, PipelineCursor oldState, BlockState newState, SpongeBlockChangeFlag flag, int limit) {
        ServerLevel world = pipeline.getServerWorld();
        BlockPos pos = oldState.pos;
        List<ItemStack> drops = oldState.drops;
        drops.forEach(drop -> Block.popResource((Level)world, (BlockPos)pos, (ItemStack)drop));
        return EffectResult.NULL_PASS;
    }

    private static final class Holder {
        static final SpawnDestructBlocksEffect INSTANCE = new SpawnDestructBlocksEffect();

        private Holder() {
        }
    }
}

