/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.inventory;

import java.util.List;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.event.item.inventory.ChangeInventoryEvent;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.entity.PlayerInventory;
import org.spongepowered.api.item.inventory.equipment.EquipmentTypes;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.inventory.InventoryBasedTransaction;

public class DropFromPlayerInventoryTransaction
extends InventoryBasedTransaction {
    private final ServerPlayer player;
    private final boolean dropAll;
    private final @Nullable Slot slot;

    public DropFromPlayerInventoryTransaction(ServerPlayer player, boolean dropAll) {
        super((Inventory)player.getInventory());
        this.player = player;
        this.dropAll = dropAll;
        this.slot = ((PlayerInventory)player.getInventory()).equipment().slot(EquipmentTypes.MAIN_HAND).orElse(null);
    }

    @Override
    Optional<ChangeInventoryEvent> createInventoryEvent(List<SlotTransaction> slotTransactions, List<Entity> entities, PhaseContext<@NonNull ?> context, Cause currentCause) {
        TrackingUtil.setCreatorReference(entities, this.player);
        Cause causeWithSpawnType = Cause.builder().from(currentCause).build(EventContext.builder().from(currentCause.context()).add(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM.get()).build());
        if (this.dropAll) {
            return Optional.of(SpongeEventFactory.createChangeInventoryEventDropFull(causeWithSpawnType, entities, this.inventory, this.slot, slotTransactions));
        }
        return Optional.of(SpongeEventFactory.createChangeInventoryEventDropSingle(causeWithSpawnType, entities, this.inventory, this.slot, slotTransactions));
    }

    @Override
    public void restore(PhaseContext<@NonNull ?> context, ChangeInventoryEvent event) {
        this.handleEventResults((Player)this.player, event);
    }

    @Override
    public void postProcessEvent(PhaseContext<@NonNull ?> context, ChangeInventoryEvent event) {
        this.handleEventResults((Player)this.player, event);
    }
}

