/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.inventory;

import java.util.List;
import java.util.Optional;
import net.minecraft.network.protocol.game.ServerboundPlaceRecipePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.item.inventory.container.ClickContainerEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.crafting.CraftingInventory;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ContainerBasedTransaction;
import org.spongepowered.common.event.tracking.phase.packet.inventory.InventoryPacketContext;
import org.spongepowered.common.item.util.ItemStackUtil;

public class PlaceRecipeTransaction
extends ContainerBasedTransaction {
    private final ServerPlayer player;
    private final ItemStackSnapshot originalCursor;
    private boolean shift;
    private RecipeHolder<Recipe<?>> recipe;
    private CraftingInventory craftingInventory;

    public PlaceRecipeTransaction(ServerPlayer player, boolean shift, RecipeHolder<Recipe<?>> recipe, CraftingInventory craftingInventory) {
        super(player.containerMenu);
        this.player = player;
        this.originalCursor = ItemStackUtil.snapshotOf(player.containerMenu.getCarried());
        this.shift = shift;
        this.recipe = recipe;
        this.craftingInventory = craftingInventory;
    }

    @Override
    Optional<ClickContainerEvent> createInventoryEvent(List<SlotTransaction> slotTransactions, List<Entity> entities, PhaseContext<@NonNull ?> context, Cause cause) {
        SlotTransaction preview = this.getPreviewTransaction(this.craftingInventory.result(), slotTransactions);
        Transaction<ItemStackSnapshot> cursorTransaction = new Transaction<ItemStackSnapshot>(this.originalCursor, ItemStackUtil.snapshotOf(this.player.containerMenu.getCarried()));
        ClickContainerEvent.Recipe event = this.shift ? SpongeEventFactory.createClickContainerEventRecipeAll(cause, (Container)this.menu, this.craftingInventory, cursorTransaction, preview, Optional.of(this.recipe).map(RecipeHolder::value).map(CraftingRecipe.class::cast), Optional.of(this.recipe).map(RecipeHolder::id).map(ResourceKey.class::cast), Optional.empty(), slotTransactions) : SpongeEventFactory.createClickContainerEventRecipeSingle(cause, (Container)this.menu, this.craftingInventory, cursorTransaction, preview, Optional.of(this.recipe).map(RecipeHolder::value).map(CraftingRecipe.class::cast), Optional.of(this.recipe).map(RecipeHolder::id).map(ResourceKey.class::cast), Optional.empty(), slotTransactions);
        return Optional.of(event);
    }

    @Override
    public void restore(PhaseContext<@NonNull ?> context, ClickContainerEvent event) {
        this.handleEventResults((Player)this.player, event);
    }

    @Override
    public void postProcessEvent(PhaseContext<@NonNull ?> context, ClickContainerEvent event) {
        this.handleEventResults((Player)this.player, event);
    }

    @Override
    boolean isContainerEventAllowed(PhaseContext<@Nullable ?> context) {
        if (!(context instanceof InventoryPacketContext)) {
            return false;
        }
        int containerId = ((ServerboundPlaceRecipePacket)((InventoryPacketContext)context).getPacket()).getContainerId();
        return containerId != this.player.containerMenu.containerId;
    }
}

