/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.tick.BlockTickContext;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickPhaseState;
import org.spongepowered.common.world.BlockChange;

class BlockTickPhaseState
extends LocationBasedTickPhaseState<BlockTickContext> {
    private final String desc;

    BlockTickPhaseState(String name) {
        this.desc = TrackingUtil.phaseStateToString("Tick", name, this);
    }

    @Override
    public BlockTickContext createNewContext(PhaseTracker tracker) {
        return new BlockTickContext(this, tracker);
    }

    @Override
    public boolean shouldProvideModifiers(BlockTickContext phaseContext) {
        return phaseContext.providesModifier;
    }

    @Override
    public BlockChange associateBlockChangeWithSnapshot(BlockTickContext phaseContext, BlockState newState, BlockState currentState) {
        Block newBlock = newState.getBlock();
        if (phaseContext.tickingBlock instanceof BonemealableBlock) {
            if (newBlock == Blocks.AIR) {
                return BlockChange.BREAK;
            }
            if (newBlock instanceof BonemealableBlock || newState.ignitedByLava()) {
                return BlockChange.GROW;
            }
        }
        return super.associateBlockChangeWithSnapshot(phaseContext, newState, currentState);
    }

    @Override
    public String toString() {
        return this.desc;
    }
}

