/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.adapter.impl.slots;

import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.slot.FilteringSlot;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.common.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.impl.slot.FilteringSlotLens;
import org.spongepowered.common.item.util.ItemStackUtil;

public class FilteringSlotAdapter
extends SlotAdapter
implements FilteringSlot {
    protected final FilteringSlotLens filteringSlot;

    public FilteringSlotAdapter(Fabric fabric, FilteringSlotLens lens, Inventory parent) {
        super(fabric, lens, parent);
        this.filteringSlot = lens;
    }

    @Override
    public boolean isValidItem(ItemStack stack) {
        FilteringSlotLens.ItemStackFilter filter = this.filteringSlot.getItemStackFilter();
        return filter == null || filter.test(this.impl$getFabric(), stack);
    }

    @Override
    public boolean isValidItem(ItemType type) {
        return this.isValidItem(ItemStack.of(type));
    }

    @Override
    public InventoryTransactionResult set(ItemStack stack) {
        boolean canSet = this.isValidItem(stack);
        if (!canSet) {
            InventoryTransactionResult.Builder result = InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.FAILURE);
            result.reject(ItemStackUtil.cloneDefensive(stack));
            return result.build();
        }
        return super.set(stack);
    }
}

