/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.lens.impl.slot;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.common.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.InvalidOrdinalException;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.AbstractLens;
import org.spongepowered.common.inventory.lens.slots.SlotLens;

public class BasicSlotLens
extends AbstractLens
implements SlotLens {
    public BasicSlotLens(int index) {
        this(index, SlotAdapter.class);
    }

    public BasicSlotLens(int index, Class<? extends Inventory> adapterType) {
        super(index, 1, adapterType);
    }

    @Override
    public Slot getAdapter(Fabric fabric, Inventory parent) {
        return new SlotAdapter(fabric, this, parent);
    }

    @Override
    public List<Lens> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public List<Lens> getSpanningChildren() {
        return Collections.emptyList();
    }

    @Override
    public int getOrdinal(Fabric fabric) {
        return this.base;
    }

    @Override
    public ItemStack getStack(Fabric fabric, int ordinal) {
        if (ordinal != 0) {
            throw new InvalidOrdinalException("Non-zero slot ordinal");
        }
        return this.getStack(fabric);
    }

    @Override
    public ItemStack getStack(Fabric fabric) {
        return Objects.requireNonNull(fabric, "Target inventory").fabric$getStack(this.base);
    }

    @Override
    public boolean setStack(Fabric fabric, int ordinal, ItemStack stack) {
        if (ordinal != 0) {
            throw new InvalidOrdinalException("Non-zero slot ordinal");
        }
        return this.setStack(fabric, stack);
    }

    @Override
    public boolean setStack(Fabric fabric, ItemStack stack) {
        Objects.requireNonNull(fabric, "Target inventory").fabric$setStack(this.base, stack);
        return true;
    }

    @Override
    public Lens getLens(int index) {
        return this;
    }

    @Override
    public boolean has(Lens lens) {
        return false;
    }

    @Override
    public boolean isSubsetOf(Collection<Lens> c) {
        return false;
    }

    @Override
    public SlotLens getSlotLens(Fabric fabric, int ordinal) {
        if (ordinal != 0) {
            throw new InvalidOrdinalException("Non-zero slot ordinal");
        }
        return this;
    }

    @Override
    public List<SlotLens> getSlots(Fabric fabric) {
        return Collections.singletonList(this);
    }

    @Override
    public String toString(int deep) {
        return "[" + this.base + "]";
    }
}

