/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.spongepowered.api.item.FireworkEffect;
import org.spongepowered.api.item.FireworkShape;
import org.spongepowered.api.item.FireworkShapes;
import org.spongepowered.api.util.Color;
import org.spongepowered.common.item.SpongeFireworkEffect;

public final class SpongeFireworkEffectBuilder
implements FireworkEffect.Builder {
    private boolean trail = false;
    private boolean flicker = false;
    private List<Color> colors = Lists.newArrayList();
    private List<Color> fades = Lists.newArrayList();
    private Supplier<FireworkShape> shape = FireworkShapes.SMALL_BALL;

    @Override
    public SpongeFireworkEffectBuilder trail(boolean trail) {
        this.trail = trail;
        return this;
    }

    @Override
    public SpongeFireworkEffectBuilder flicker(boolean flicker) {
        this.flicker = flicker;
        return this;
    }

    @Override
    public SpongeFireworkEffectBuilder color(Color color) {
        Objects.requireNonNull(color);
        this.colors.add(color);
        return this;
    }

    @Override
    public SpongeFireworkEffectBuilder colors(Color ... colors) {
        Objects.requireNonNull(colors);
        Collections.addAll(this.colors, colors);
        return this;
    }

    @Override
    public SpongeFireworkEffectBuilder colors(Iterable<Color> colors) {
        Objects.requireNonNull(colors);
        for (Color color : colors) {
            this.colors.add(color);
        }
        return this;
    }

    @Override
    public SpongeFireworkEffectBuilder fade(Color color) {
        Objects.requireNonNull(color);
        this.fades.add(color);
        return this;
    }

    @Override
    public SpongeFireworkEffectBuilder fades(Color ... colors) {
        Objects.requireNonNull(colors);
        Collections.addAll(this.fades, colors);
        return this;
    }

    @Override
    public SpongeFireworkEffectBuilder fades(Iterable<Color> colors) {
        Objects.requireNonNull(colors);
        for (Color color : colors) {
            this.fades.add(color);
        }
        return this;
    }

    @Override
    public SpongeFireworkEffectBuilder shape(FireworkShape shape) {
        Objects.requireNonNull(shape);
        this.shape = () -> shape;
        return this;
    }

    @Override
    public FireworkEffect build() {
        return new SpongeFireworkEffect(this.flicker, this.trail, this.colors, this.fades, this.shape.get());
    }

    @Override
    public FireworkEffect.Builder from(FireworkEffect value) {
        return ((SpongeFireworkEffectBuilder)((SpongeFireworkEffectBuilder)this.trail(value.hasTrail()).colors(value.colors())).fades(value.fadeColors())).shape(value.shape()).flicker(value.flickers());
    }

    @Override
    public SpongeFireworkEffectBuilder reset() {
        this.trail = false;
        this.flicker = false;
        this.colors = Lists.newArrayList();
        this.fades = Lists.newArrayList();
        this.shape = FireworkShapes.SMALL_BALL;
        return this;
    }
}

