/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.attribute.AttributeModifier;
import org.spongepowered.api.entity.attribute.type.AttributeType;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.item.SpongeItemStackSnapshot;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.Preconditions;

public final class SpongeItemStack {

    public static final class FactoryImpl
    implements ItemStack.Factory {
        @Override
        public org.spongepowered.api.item.inventory.ItemStack empty() {
            return (org.spongepowered.api.item.inventory.ItemStack)ItemStack.EMPTY;
        }
    }

    public static final class BuilderImpl
    extends AbstractDataBuilder<org.spongepowered.api.item.inventory.ItemStack>
    implements ItemStack.Builder {
        private ItemType type;
        private int quantity;
        private @Nullable LinkedHashMap<Key<?>, Object> keyValues;
        private @Nullable CompoundTag compound;

        public BuilderImpl() {
            super(org.spongepowered.api.item.inventory.ItemStack.class, 1);
            this.reset();
        }

        @Override
        public ItemStack.Builder itemType(ItemType itemType) {
            Objects.requireNonNull(itemType, "Item type cannot be null");
            this.type = itemType;
            return this;
        }

        @Override
        public ItemType currentItem() {
            return this.type == null ? BlockTypes.AIR.get().item().get() : this.type;
        }

        @Override
        public ItemStack.Builder quantity(int quantity) throws IllegalArgumentException {
            Preconditions.checkArgument(quantity >= 0, "Quantity must not be smaller than 0");
            this.quantity = quantity;
            return this;
        }

        @Override
        public <V> ItemStack.Builder add(Key<? extends Value<V>> key, V value) throws IllegalArgumentException {
            if (this.keyValues == null) {
                this.keyValues = new LinkedHashMap();
            }
            this.keyValues.put(Objects.requireNonNull(key, "Key cannot be null!"), Objects.requireNonNull(value, "Value cannot be null!"));
            return this;
        }

        @Override
        public ItemStack.Builder fromItemStack(org.spongepowered.api.item.inventory.ItemStack itemStack) {
            Objects.requireNonNull(itemStack, "Item stack cannot be null");
            this.type = itemStack.type();
            this.quantity = itemStack.quantity();
            if (itemStack instanceof ItemStack) {
                CompoundTag itemCompound = ((ItemStack)itemStack).getTag();
                this.compound = itemCompound != null && !itemCompound.isEmpty() ? itemCompound.copy() : null;
            }
            return this;
        }

        @Override
        public ItemStack.Builder attributeModifier(AttributeType attributeType, AttributeModifier modifier, EquipmentType equipmentType) {
            CompoundTag compound;
            Objects.requireNonNull(attributeType, "AttributeType cannot be null");
            Objects.requireNonNull(modifier, "AttributeModifier cannot be null");
            Objects.requireNonNull(equipmentType, "EquipmentType cannot be null");
            if (this.compound == null) {
                this.compound = new CompoundTag();
            }
            if (!(compound = this.compound).contains("AttributeModifiers", 9)) {
                compound.put("AttributeModifiers", (Tag)new ListTag());
            }
            ListTag attributeModifiers = compound.getList("AttributeModifiers", 10);
            return this;
        }

        private void writeAttributeModifier(ListTag attributeModifiers, net.minecraft.world.entity.ai.attributes.AttributeModifier attributeModifier, EquipmentSlot slot) {
        }

        @Override
        public ItemStack.Builder fromContainer(DataView container) {
            Objects.requireNonNull(container);
            if (!container.contains(Constants.ItemStack.TYPE, Constants.ItemStack.COUNT)) {
                return this;
            }
            this.reset();
            int count = container.getInt(Constants.ItemStack.COUNT).get();
            this.quantity(count);
            ItemType itemType = container.getRegistryValue(Constants.ItemStack.TYPE, RegistryTypes.ITEM_TYPE, SpongeCommon.game()).get();
            this.itemType(itemType);
            if (container.contains(Constants.Sponge.UNSAFE_NBT)) {
                CompoundTag compound = NBTTranslator.INSTANCE.translate(container.getView(Constants.Sponge.UNSAFE_NBT).get());
                if (compound.contains("SpongeData", 10)) {
                    compound.remove("SpongeData");
                }
                this.compound = !compound.isEmpty() ? compound : null;
            }
            if (container.contains(Constants.Sponge.DATA_MANIPULATORS)) {
                List<DataView> list = container.getViewList(Constants.Sponge.DATA_MANIPULATORS).get();
            }
            return this;
        }

        @Override
        public ItemStack.Builder fromSnapshot(ItemStackSnapshot snapshot) {
            Objects.requireNonNull(snapshot, "The snapshot was null!");
            this.itemType(snapshot.type());
            this.quantity(snapshot.quantity());
            for (Value.Immutable value : snapshot.getValues()) {
                this.add(value);
            }
            if (snapshot instanceof SpongeItemStackSnapshot) {
                this.compound = ((SpongeItemStackSnapshot)snapshot).getCompound().orElse(null);
            }
            return this;
        }

        @Override
        public ItemStack.Builder fromBlockSnapshot(BlockSnapshot blockSnapshot) {
            Optional<CompoundTag> compound;
            Objects.requireNonNull(blockSnapshot, "The snapshot was null!");
            this.reset();
            BlockType blockType = blockSnapshot.state().type();
            ResourceLocation blockTypeKey = SpongeCommon.vanillaRegistry(Registries.BLOCK).getKey((Object)((Block)blockType));
            Optional<ItemType> itemType = blockType.item();
            this.itemType(itemType.orElseThrow(() -> new IllegalArgumentException("ItemType not found for block type: " + blockTypeKey)));
            this.quantity(1);
            if (blockSnapshot instanceof SpongeBlockSnapshot && (compound = ((SpongeBlockSnapshot)blockSnapshot).getCompound()).isPresent()) {
                this.compound = new CompoundTag();
                this.compound.put("BlockEntityTag", (Tag)compound.get());
            }
            return this;
        }

        @Override
        public ItemStack.Builder fromBlockState(BlockState blockState) {
            Objects.requireNonNull(blockState, "blockState");
            BlockType blockType = blockState.type();
            ResourceLocation blockTypeKey = SpongeCommon.vanillaRegistry(Registries.BLOCK).getKey((Object)((Block)blockType));
            this.itemType(blockType.item().orElseThrow(() -> new IllegalArgumentException("Missing valid ItemType for BlockType: " + blockTypeKey)));
            blockState.getValues().forEach(this::add);
            return this;
        }

        @Override
        public ItemStack.Builder from(org.spongepowered.api.item.inventory.ItemStack value) {
            return this.fromItemStack(value);
        }

        @Override
        protected Optional<org.spongepowered.api.item.inventory.ItemStack> buildContent(DataView container) throws InvalidDataException {
            CompoundTag compound;
            Objects.requireNonNull(container);
            if (!container.contains(Constants.ItemStack.TYPE, Constants.ItemStack.COUNT)) {
                return Optional.empty();
            }
            int count = container.getInt(Constants.ItemStack.COUNT).get();
            ItemType itemType = container.getRegistryValue(Constants.ItemStack.TYPE, RegistryTypes.ITEM_TYPE, SpongeCommon.game()).orElseThrow(() -> new IllegalStateException("Unable to find item with id: "));
            ItemStack itemStack = new ItemStack((ItemLike)((Item)itemType), count);
            if (container.contains(Constants.Sponge.UNSAFE_NBT) && !(compound = NBTTranslator.INSTANCE.translate(container.getView(Constants.Sponge.UNSAFE_NBT).get())).isEmpty()) {
                BuilderImpl.fixEnchantmentData(itemType, compound);
                itemStack.setTag(compound);
            }
            if (container.contains(Constants.Sponge.DATA_MANIPULATORS)) {
                List<DataView> list = container.getViewList(Constants.Sponge.DATA_MANIPULATORS).get();
            }
            return Optional.of((org.spongepowered.api.item.inventory.ItemStack)itemStack);
        }

        @Override
        public ItemStack.Builder reset() {
            this.type = null;
            this.quantity = 1;
            this.compound = null;
            return this;
        }

        @Override
        public org.spongepowered.api.item.inventory.ItemStack build() throws IllegalStateException {
            CompoundTag compoundTag;
            Preconditions.checkState(this.type != null, "Item type has not been set");
            if (this.type == null || this.quantity <= 0) {
                return (org.spongepowered.api.item.inventory.ItemStack)ItemStack.EMPTY;
            }
            org.spongepowered.api.item.inventory.ItemStack stack = (org.spongepowered.api.item.inventory.ItemStack)new ItemStack((ItemLike)((Item)this.type), this.quantity);
            if (this.compound != null && !this.compound.isEmpty()) {
                ((ItemStack)stack).setTag(this.compound.copy());
            }
            if (this.keyValues != null) {
                this.keyValues.forEach((key, value) -> stack.offer(key, value));
            }
            if (this.compound != null && this.compound.contains("ForgeCaps", 10) && (compoundTag = this.compound.getCompound("ForgeCaps")) != null) {
                PlatformHooks.INSTANCE.getItemHooks().setCapabilitiesFromSpongeBuilder((ItemStack)stack, compoundTag);
            }
            return stack;
        }

        public static void fixEnchantmentData(ItemType itemType, CompoundTag compound) {
            ListTag nbttaglist = itemType == Items.ENCHANTED_BOOK ? compound.getList("StoredEnchantments", 10) : compound.getList("Enchantments", 10);
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundTag nbttagcompound = nbttaglist.getCompound(i);
                short lvl = nbttagcompound.getShort("lvl");
                nbttagcompound.putShort("lvl", lvl);
            }
        }
    }
}

