/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.event.HoverEvent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.MergeFunction;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.data.SpongeDataHolderBridge;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.Constants;

public class SpongeItemStackSnapshot
implements ItemStackSnapshot {
    public static final ItemStackSnapshot EMPTY = new SpongeItemStackSnapshot(ItemStackUtil.fromNative(ItemStack.EMPTY));
    private final ItemType itemType;
    private final int quantity;
    private final int damageValue;
    private final ImmutableList<DataManipulator.Immutable> manipulators;
    private final transient org.spongepowered.api.item.inventory.ItemStack privateStack;
    private final ImmutableSet<org.spongepowered.api.data.Key<?>> keys;
    private final ImmutableSet<Value.Immutable<?>> values;
    private final @Nullable CompoundTag compound;
    private @Nullable UUID creatorUniqueId;

    public SpongeItemStackSnapshot(org.spongepowered.api.item.inventory.ItemStack itemStack) {
        Objects.requireNonNull(itemStack);
        if (ItemStackUtil.toNative(itemStack) == ItemStack.EMPTY) {
            this.itemType = itemStack.type();
            this.quantity = 0;
            this.damageValue = 0;
            this.manipulators = ImmutableList.of();
            this.privateStack = itemStack;
            this.keys = ImmutableSet.of();
            this.values = ImmutableSet.of();
            this.compound = null;
            return;
        }
        this.itemType = itemStack.type();
        this.quantity = itemStack.quantity();
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableSet.Builder keyBuilder = ImmutableSet.builder();
        ImmutableSet.Builder valueBuilder = ImmutableSet.builder();
        DataManipulator.Mutable customData = ((SpongeDataHolderBridge)((Object)itemStack)).bridge$getManipulator();
        builder.add((Object)customData.asImmutable());
        keyBuilder.addAll(customData.getKeys());
        valueBuilder.addAll(customData.getValues());
        this.damageValue = ItemStackUtil.toNative(itemStack).getDamageValue();
        this.manipulators = builder.build();
        this.privateStack = itemStack.copy();
        this.keys = keyBuilder.build();
        this.values = valueBuilder.build();
        @Nullable CompoundTag compound = ItemStackUtil.toNative(this.privateStack).getTag();
        if (compound != null) {
            compound = compound.copy();
        }
        if (compound != null) {
            CompoundTag spongeCompound;
            if (compound.contains("SpongeData") && (spongeCompound = compound.getCompound("SpongeData")).contains("CustomManipulators")) {
                spongeCompound.remove("CustomManipulators");
            }
            Constants.NBT.filterSpongeCustomData(compound);
            this.compound = !compound.isEmpty() ? compound : null;
        } else {
            this.compound = null;
        }
    }

    public SpongeItemStackSnapshot(ItemType itemType, int quantity, ImmutableList<DataManipulator.Immutable> manipulators, @Nullable CompoundTag compound) {
        this.itemType = Objects.requireNonNull(itemType);
        this.quantity = quantity;
        this.manipulators = Objects.requireNonNull(manipulators);
        this.privateStack = ItemStackUtil.fromNative(new ItemStack((ItemLike)((Item)this.itemType), this.quantity));
        ImmutableSet.Builder keyBuilder = ImmutableSet.builder();
        ImmutableSet.Builder valueBuilder = ImmutableSet.builder();
        for (DataManipulator.Immutable manipulator : this.manipulators) {
            this.privateStack.copyFrom(manipulator);
            keyBuilder.addAll(manipulator.getKeys());
            valueBuilder.addAll(manipulator.getValues());
        }
        this.keys = keyBuilder.build();
        this.values = valueBuilder.build();
        this.compound = compound == null ? null : compound.copy();
        this.damageValue = 0;
    }

    @Override
    public ItemType type() {
        return this.itemType == null ? (ItemType)ItemStack.EMPTY.getItem() : this.itemType;
    }

    @Override
    public int quantity() {
        return this.quantity;
    }

    @Override
    public boolean isEmpty() {
        return this.privateStack.isEmpty();
    }

    public boolean isNone() {
        throw new UnsupportedOperationException("Implement is empty");
    }

    @Override
    public org.spongepowered.api.item.inventory.ItemStack createStack() {
        ItemStack nativeStack = ItemStackUtil.cloneDefensiveNative(ItemStackUtil.toNative(this.privateStack.copy()));
        if (this.compound != null) {
            nativeStack.setTag(this.compound.copy());
        }
        for (DataManipulator.Immutable manipulator : this.manipulators) {
            ((org.spongepowered.api.item.inventory.ItemStack)nativeStack).copyFrom(manipulator);
        }
        return ItemStackUtil.fromNative(nativeStack);
    }

    @Override
    public int contentVersion() {
        return 2;
    }

    @Override
    public DataContainer toContainer() {
        ResourceKey resourceKey = Sponge.game().registry(RegistryTypes.ITEM_TYPE).valueKey(this.itemType);
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, this.contentVersion()).set(Constants.ItemStack.TYPE, resourceKey).set(Constants.ItemStack.COUNT, this.quantity).set(Constants.ItemStack.DAMAGE_VALUE, this.damageValue);
        if (!this.manipulators.isEmpty()) {
            // empty if block
        }
        if (this.compound != null) {
            container.set(Constants.Sponge.UNSAFE_NBT, NBTTranslator.INSTANCE.translateFrom(this.compound));
        }
        return container;
    }

    @Override
    public <E> Optional<ItemStackSnapshot> transform(org.spongepowered.api.data.Key<? extends Value<E>> key, Function<E, E> function) {
        org.spongepowered.api.item.inventory.ItemStack copy = this.privateStack.copy();
        DataTransactionResult result = copy.transform(key, function);
        if (result.type() != DataTransactionResult.Type.SUCCESS) {
            return Optional.empty();
        }
        return Optional.of(copy.createSnapshot());
    }

    @Override
    public <E> Optional<ItemStackSnapshot> with(org.spongepowered.api.data.Key<? extends Value<E>> key, E value) {
        org.spongepowered.api.item.inventory.ItemStack copy = this.privateStack.copy();
        DataTransactionResult result = copy.offer(key, value);
        if (result.type() != DataTransactionResult.Type.SUCCESS) {
            return Optional.empty();
        }
        return Optional.of(copy.createSnapshot());
    }

    @Override
    public Optional<ItemStackSnapshot> with(Value<?> value) {
        return this.with(value.key(), value.get());
    }

    @Override
    public <E> Optional<E> get(org.spongepowered.api.data.Key<? extends Value<E>> key) {
        return this.privateStack.get(key);
    }

    @Override
    public <E, V extends Value<E>> Optional<V> getValue(org.spongepowered.api.data.Key<V> key) {
        return this.privateStack.getValue(key);
    }

    @Override
    public boolean supports(org.spongepowered.api.data.Key<?> key) {
        return this.privateStack.supports(key);
    }

    @Override
    public ItemStackSnapshot copy() {
        return this;
    }

    @Override
    public Set<org.spongepowered.api.data.Key<?>> getKeys() {
        return this.keys;
    }

    @Override
    public Set<Value.Immutable<?>> getValues() {
        return this.values;
    }

    public String toString() {
        ResourceKey resourceKey = Sponge.game().registry(RegistryTypes.ITEM_TYPE).valueKey(this.itemType);
        return new StringJoiner(", ", SpongeItemStackSnapshot.class.getSimpleName() + "[", "]").add("itemType=" + resourceKey).add("quantity=" + this.quantity).toString();
    }

    public int getDamageValue() {
        return this.damageValue;
    }

    public Optional<CompoundTag> getCompound() {
        if (this.compound != null) {
            return Optional.of(this.compound.copy());
        }
        return Optional.empty();
    }

    public Optional<UUID> getCreator() {
        return Optional.ofNullable(this.creatorUniqueId);
    }

    public void setCreator(@Nullable UUID uuid) {
        if (uuid != null) {
            this.creatorUniqueId = uuid;
        }
    }

    @Override
    public ItemStackSnapshot withRawData(DataView container) throws InvalidDataException {
        org.spongepowered.api.item.inventory.ItemStack copy = this.privateStack.copy();
        copy.setRawData(container);
        return copy.createSnapshot();
    }

    @Override
    public Optional<ItemStackSnapshot> without(org.spongepowered.api.data.Key<?> key) {
        org.spongepowered.api.item.inventory.ItemStack copy = this.privateStack.copy();
        DataTransactionResult result = copy.remove(key);
        if (result.type() != DataTransactionResult.Type.SUCCESS) {
            return Optional.empty();
        }
        return Optional.of(copy.createSnapshot());
    }

    @Override
    public ItemStackSnapshot mergeWith(ItemStackSnapshot that, MergeFunction function) {
        org.spongepowered.api.item.inventory.ItemStack copy = this.privateStack.copy();
        copy.copyFrom(that, function);
        return copy.createSnapshot();
    }

    @Override
    public boolean validateRawData(DataView container) {
        org.spongepowered.api.item.inventory.ItemStack copy = this.privateStack.copy();
        return copy.validateRawData(container);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeItemStackSnapshot that = (SpongeItemStackSnapshot)o;
        return this.quantity == that.quantity && this.damageValue == that.damageValue && Objects.equals(this.itemType, that.itemType) && Objects.equals(this.compound, that.compound) && Objects.equals(this.creatorUniqueId, that.creatorUniqueId);
    }

    public int hashCode() {
        return Objects.hash(this.itemType, this.quantity, this.damageValue, this.compound, this.creatorUniqueId);
    }

    public HoverEvent<HoverEvent.ShowItem> asHoverEvent(UnaryOperator<HoverEvent.ShowItem> op) {
        ResourceKey resourceKey = Sponge.game().registry(RegistryTypes.ITEM_TYPE).valueKey(this.itemType);
        CompoundTag tag = this.getCompound().orElse(null);
        return HoverEvent.showItem((HoverEvent.ShowItem)((HoverEvent.ShowItem)op.apply(HoverEvent.ShowItem.of((Key)resourceKey, (int)this.quantity(), (BinaryTagHolder)SpongeAdventure.asBinaryTagHolder(tag)))));
    }
}

