/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.cooking;

import java.util.Objects;
import java.util.function.Function;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.api.item.recipe.RecipeType;
import org.spongepowered.api.item.recipe.cooking.CookingRecipe;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.common.inventory.util.InventoryUtil;
import org.spongepowered.common.item.recipe.cooking.SpongeCookingRecipeRegistration;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.AbstractResourceKeyedBuilder;

public final class SpongeCookingRecipeBuilder
extends AbstractResourceKeyedBuilder<RecipeRegistration, CookingRecipe.Builder>
implements CookingRecipe.Builder.ResultStep,
CookingRecipe.Builder.IngredientStep,
CookingRecipe.Builder.EndStep {
    private net.minecraft.world.item.crafting.RecipeType<?> type;
    private Ingredient ingredient;
    private ItemStack result;
    private Function<Container, ItemStack> resultFunction;
    private @Nullable Float experience;
    private @Nullable Ticks cookingTime;
    private @Nullable String group;
    private DataPack<RecipeRegistration> pack = DataPacks.RECIPE;
    private RecipeCategory recipeCategory = RecipeCategory.MISC;
    private CookingBookCategory cookingCategory = CookingBookCategory.MISC;

    @Override
    public CookingRecipe.Builder.ResultStep ingredient(org.spongepowered.api.item.recipe.crafting.Ingredient ingredient) {
        this.ingredient = (Ingredient)ingredient;
        return this;
    }

    @Override
    public CookingRecipe.Builder reset() {
        super.reset();
        this.type = null;
        this.ingredient = null;
        this.result = null;
        this.resultFunction = null;
        this.experience = null;
        this.cookingTime = null;
        this.group = null;
        this.pack = DataPacks.RECIPE;
        return this;
    }

    @Override
    public CookingRecipe.Builder.EndStep result(ItemType result) {
        this.result = new ItemStack((ItemLike)((Item)result));
        this.resultFunction = null;
        return this;
    }

    @Override
    public CookingRecipe.Builder.EndStep result(org.spongepowered.api.item.inventory.ItemStack result) {
        this.result = ItemStackUtil.toNative(result);
        this.resultFunction = null;
        return this;
    }

    @Override
    public CookingRecipe.Builder.EndStep result(ItemStackSnapshot result) {
        return this.result(result.createStack());
    }

    @Override
    public CookingRecipe.Builder.EndStep result(Function<Inventory, org.spongepowered.api.item.inventory.ItemStack> resultFunction, org.spongepowered.api.item.inventory.ItemStack exemplaryResult) {
        this.result = ItemStackUtil.toNative(exemplaryResult);
        this.resultFunction = inv -> ItemStackUtil.toNative((org.spongepowered.api.item.inventory.ItemStack)resultFunction.apply(InventoryUtil.toInventory(inv)));
        return this;
    }

    @Override
    public CookingRecipe.Builder.EndStep experience(double experience) {
        if (experience < 0.0) {
            throw new IllegalStateException("The experience must be non-negative");
        }
        this.experience = Float.valueOf((float)experience);
        return this;
    }

    @Override
    public CookingRecipe.Builder.EndStep cookingTime(Ticks ticks) {
        this.cookingTime = Objects.requireNonNull(ticks);
        return this;
    }

    @Override
    public CookingRecipe.Builder.IngredientStep type(RecipeType<CookingRecipe> type) {
        this.type = (net.minecraft.world.item.crafting.RecipeType)type;
        return this;
    }

    @Override
    public CookingRecipe.Builder.EndStep group(String group) {
        this.group = group;
        return this;
    }

    @Override
    public CookingRecipe.Builder.EndStep pack(DataPack<RecipeRegistration> pack) {
        this.pack = pack;
        return this;
    }

    @Override
    protected RecipeRegistration build0() {
        Objects.requireNonNull(this.type, "type");
        Objects.requireNonNull(this.ingredient, "ingredient");
        Objects.requireNonNull(this.result, "result");
        return SpongeCookingRecipeRegistration.of((ResourceLocation)this.key, this.type, this.group, this.ingredient, this.experience, this.cookingTime, this.result, this.resultFunction, this.pack, this.recipeCategory, this.cookingCategory);
    }
}

