/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.crafting.custom;

import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.crafting.CraftingGridInventory;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.api.item.recipe.crafting.SpecialCraftingRecipe;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.item.recipe.crafting.custom.SpongeSpecialCraftingRecipeRegistration;
import org.spongepowered.common.util.AbstractResourceKeyedBuilder;

public final class SpongeSpecialCraftingRecipeBuilder
extends AbstractResourceKeyedBuilder<RecipeRegistration, SpecialCraftingRecipe.Builder>
implements SpecialCraftingRecipe.Builder,
SpecialCraftingRecipe.Builder.ResultStep,
SpecialCraftingRecipe.Builder.EndStep {
    private BiPredicate<CraftingGridInventory, ServerWorld> biPredicate;
    private Function<CraftingGridInventory, List<ItemStack>> remainingItemsFunction;
    private Function<CraftingGridInventory, ItemStack> resultFunction;
    private DataPack<RecipeRegistration> pack = DataPacks.RECIPE;
    private RecipeCategory recipeCategory = RecipeCategory.MISC;

    @Override
    public SpecialCraftingRecipe.Builder.ResultStep matching(BiPredicate<CraftingGridInventory, ServerWorld> biPredicate) {
        this.biPredicate = biPredicate;
        return this;
    }

    @Override
    public SpecialCraftingRecipe.Builder.ResultStep remainingItems(Function<CraftingGridInventory, List<ItemStack>> remainingItemsFunction) {
        this.remainingItemsFunction = remainingItemsFunction;
        return this;
    }

    @Override
    public SpecialCraftingRecipe.Builder.EndStep result(Function<CraftingGridInventory, ItemStack> resultFunction) {
        this.resultFunction = resultFunction;
        return this;
    }

    @Override
    public SpecialCraftingRecipe.Builder.EndStep result(ItemStack result) {
        ItemStack copy = result.copy();
        this.resultFunction = inv -> copy.copy();
        return this;
    }

    @Override
    public SpecialCraftingRecipe.Builder.EndStep pack(DataPack<RecipeRegistration> pack) {
        this.pack = pack;
        return this;
    }

    @Override
    public RecipeRegistration build0() {
        ResourceLocation resourceLocation = (ResourceLocation)this.key;
        return new SpongeSpecialCraftingRecipeRegistration(resourceLocation, CraftingBookCategory.MISC, this.biPredicate, this.remainingItemsFunction, this.resultFunction, this.pack, this.recipeCategory);
    }

    @Override
    public SpecialCraftingRecipe.Builder reset() {
        super.reset();
        this.biPredicate = null;
        this.remainingItemsFunction = null;
        this.resultFunction = null;
        this.pack = DataPacks.RECIPE;
        return this;
    }
}

