/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.crafting.shaped;

import java.util.Collection;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.item.recipe.Recipe;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.api.item.recipe.crafting.ShapedCraftingRecipe;
import org.spongepowered.common.item.recipe.SpongeRecipeRegistration;
import org.spongepowered.common.item.recipe.crafting.shaped.SpongeShapedRecipe;

public class SpongeShapedCraftingRecipeRegistration
extends SpongeRecipeRegistration<ShapedRecipe>
implements SpongeRecipeRegistration.ResultFunctionRegistration<CraftingContainer>,
SpongeRecipeRegistration.RemainingItemsFunctionRegistration<CraftingContainer> {
    private final ShapedRecipePattern pattern;
    private final ItemStack spongeResult;
    private final Function<CraftingContainer, ItemStack> resultFunction;
    private final Function<CraftingContainer, NonNullList<ItemStack>> remainingItemsFunction;
    private final CraftingBookCategory craftingBookCategory;
    private final boolean showNotification = true;

    public SpongeShapedCraftingRecipeRegistration(ResourceLocation key, String group, ShapedRecipePattern pattern, ItemStack spongeResult, Function<CraftingContainer, ItemStack> resultFunction, Function<CraftingContainer, NonNullList<ItemStack>> remainingItemsFunction, DataPack<RecipeRegistration> pack, RecipeCategory category, CraftingBookCategory craftingBookCategory) {
        super(key, group, pack, category, RecipeSerializer.SHAPED_RECIPE);
        this.pattern = pattern;
        this.spongeResult = spongeResult;
        this.resultFunction = resultFunction;
        this.remainingItemsFunction = remainingItemsFunction;
        this.craftingBookCategory = craftingBookCategory;
    }

    @Override
    public Function<CraftingContainer, ItemStack> resultFunction() {
        return this.resultFunction;
    }

    @Override
    public Function<CraftingContainer, NonNullList<ItemStack>> remainingItems() {
        return this.remainingItemsFunction;
    }

    @Override
    public Recipe recipe() {
        if (SpongeRecipeRegistration.isVanillaSerializer(this.spongeResult, this.resultFunction, this.remainingItemsFunction, (Collection<Ingredient>)this.pattern.ingredients())) {
            return (ShapedCraftingRecipe)new ShapedRecipe(this.group, this.craftingBookCategory, this.pattern, this.spongeResult, this.showNotification);
        }
        this.ensureCached();
        return (ShapedCraftingRecipe)((Object)new SpongeShapedRecipe(this.group, this.craftingBookCategory, this.pattern, this.showNotification, this.spongeResult, this.resultFunction == null ? null : this.key.toString(), this.remainingItemsFunction == null ? null : this.key.toString()));
    }
}

