/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.crafting.shaped;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import org.spongepowered.common.bridge.world.item.crafting.RecipeResultBridge;
import org.spongepowered.common.bridge.world.item.crafting.ShapedRecipeBridge;
import org.spongepowered.common.item.recipe.ResultFunctionRecipe;
import org.spongepowered.common.item.recipe.ingredient.IngredientResultUtil;

public class SpongeShapedRecipe
extends ShapedRecipe
implements ResultFunctionRecipe {
    public static final MapCodec<SpongeShapedRecipe> SPONGE_CODEC = RecordCodecBuilder.mapCodec($$0 -> $$0.group((App)Codec.STRING.fieldOf("sponge:type").forGetter(t -> "custom"), (App)ExtraCodecs.strictOptionalField((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(ShapedRecipe::getGroup), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(ShapedRecipe::category), (App)ShapedRecipePattern.MAP_CODEC.forGetter($$0x -> ((ShapedRecipeBridge)((Object)$$0x)).bridge$pattern()), (App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("result").forGetter($$0x -> ((RecipeResultBridge)((Object)$$0x)).bridge$result()), (App)ExtraCodecs.strictOptionalField((Codec)Codec.BOOL, (String)"show_notification", (Object)true).forGetter(ShapedRecipe::showNotification), (App)ItemStack.CODEC.optionalFieldOf("sponge:result", (Object)ItemStack.EMPTY).forGetter($$0x -> ((RecipeResultBridge)((Object)$$0x)).bridge$spongeResult()), (App)IngredientResultUtil.CACHED_RESULT_FUNC_CODEC.optionalFieldOf("sponge:result_function").forGetter(ResultFunctionRecipe::resultFunctionId), (App)IngredientResultUtil.CACHED_REMAINING_FUNC_CODEC.optionalFieldOf("sponge:remaining_items").forGetter(SpongeShapedRecipe::remainingItemsFunctionId)).apply((Applicative)$$0, SpongeShapedRecipe::of));
    private final String resultFunctionId;
    private final String remainingItemsFunctionId;

    public static SpongeShapedRecipe of(String spongeType, String groupIn, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack recipeOutputIn, boolean showNotification, ItemStack spongeResultStack, Optional<String> resultFunctionId, Optional<String> remainingItemsFunctionId) {
        return new SpongeShapedRecipe(groupIn, category, pattern, showNotification, spongeResultStack.isEmpty() ? recipeOutputIn : spongeResultStack, resultFunctionId.orElse(null), remainingItemsFunctionId.orElse(null));
    }

    public SpongeShapedRecipe(String groupIn, CraftingBookCategory category, ShapedRecipePattern pattern, boolean showNotification, ItemStack spongeResultStack, String resultFunctionId, String remainingItemsFunctionId) {
        super(groupIn, category, pattern, spongeResultStack, showNotification);
        this.resultFunctionId = resultFunctionId;
        this.remainingItemsFunctionId = remainingItemsFunctionId;
    }

    @Override
    public Optional<String> resultFunctionId() {
        return Optional.ofNullable(this.resultFunctionId);
    }

    public Optional<String> remainingItemsFunctionId() {
        return Optional.ofNullable(this.remainingItemsFunctionId);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        if (this.remainingItemsFunctionId != null) {
            return IngredientResultUtil.cachedRemainingItemsFunction(this.remainingItemsFunctionId).apply(inv);
        }
        return super.getRemainingItems((Container)inv);
    }

    public ItemStack assemble(CraftingContainer $$0, RegistryAccess $$1) {
        if (this.resultFunctionId != null) {
            return IngredientResultUtil.cachedResultFunction(this.resultFunctionId).apply($$0);
        }
        return super.assemble($$0, $$1);
    }

    public ItemStack getResultItem(RegistryAccess $$0) {
        if (this.resultFunctionId != null) {
            return ItemStack.EMPTY;
        }
        return super.getResultItem($$0);
    }
}

