/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.crafting.shapeless;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.crafting.CraftingGridInventory;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.api.item.recipe.crafting.ShapelessCraftingRecipe;
import org.spongepowered.common.inventory.util.InventoryUtil;
import org.spongepowered.common.item.recipe.crafting.shapeless.SpongeShapelessCraftingRecipeRegistration;
import org.spongepowered.common.item.recipe.ingredient.IngredientUtil;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.AbstractResourceKeyedBuilder;
import org.spongepowered.common.util.Preconditions;

public class SpongeShapelessCraftingRecipeBuilder
extends AbstractResourceKeyedBuilder<RecipeRegistration, ShapelessCraftingRecipe.Builder>
implements ShapelessCraftingRecipe.Builder.EndStep,
ShapelessCraftingRecipe.Builder.ResultStep {
    private org.spongepowered.api.item.inventory.ItemStack result;
    private Function<CraftingContainer, ItemStack> resultFunction;
    private Function<CraftingContainer, NonNullList<ItemStack>> remainingItemsFunction;
    private final NonNullList<Ingredient> ingredients = NonNullList.create();
    private String group;
    private DataPack<RecipeRegistration> pack = DataPacks.RECIPE;
    private RecipeCategory recipeCategory = RecipeCategory.MISC;
    private CraftingBookCategory craftingBookCategory = CraftingBookCategory.MISC;

    @Override
    public ShapelessCraftingRecipe.Builder.ResultStep addIngredients(ItemType ... ingredients) {
        for (ItemType ingredient : ingredients) {
            this.ingredients.add((Object)Ingredient.of((ItemLike[])new ItemLike[]{() -> (Item)ingredient}));
        }
        return this;
    }

    @Override
    public ShapelessCraftingRecipe.Builder.ResultStep addIngredients(Supplier<? extends ItemType> ... ingredients) {
        for (Supplier<? extends ItemType> ingredient : ingredients) {
            this.ingredients.add((Object)Ingredient.of((ItemLike[])new ItemLike[]{() -> (Item)ingredient.get()}));
        }
        return this;
    }

    @Override
    public ShapelessCraftingRecipe.Builder.ResultStep addIngredients(org.spongepowered.api.item.recipe.crafting.Ingredient ... ingredients) {
        for (org.spongepowered.api.item.recipe.crafting.Ingredient ingredient : ingredients) {
            this.ingredients.add((Object)IngredientUtil.toNative(ingredient));
        }
        return this;
    }

    @Override
    public ShapelessCraftingRecipe.Builder.ResultStep remainingItems(Function<CraftingGridInventory, List<org.spongepowered.api.item.inventory.ItemStack>> remainingItemsFunction) {
        this.remainingItemsFunction = grid -> {
            NonNullList mcList = NonNullList.create();
            ((List)remainingItemsFunction.apply(InventoryUtil.toSpongeInventory(grid))).forEach(stack -> mcList.add((Object)ItemStackUtil.toNative(stack)));
            return mcList;
        };
        return this;
    }

    @Override
    public ShapelessCraftingRecipe.Builder.EndStep result(ItemStackSnapshot result) {
        Objects.requireNonNull(result, "result");
        this.result = result.createStack();
        this.resultFunction = null;
        return this;
    }

    @Override
    public ShapelessCraftingRecipe.Builder.EndStep result(org.spongepowered.api.item.inventory.ItemStack result) {
        Objects.requireNonNull(result, "result");
        this.result = result;
        this.resultFunction = null;
        return this;
    }

    @Override
    public ShapelessCraftingRecipe.Builder.EndStep result(Function<CraftingGridInventory, org.spongepowered.api.item.inventory.ItemStack> resultFunction, org.spongepowered.api.item.inventory.ItemStack exemplaryResult) {
        this.resultFunction = inv -> ItemStackUtil.toNative((org.spongepowered.api.item.inventory.ItemStack)resultFunction.apply(InventoryUtil.toSpongeInventory(inv)));
        this.result = exemplaryResult.copy();
        return this;
    }

    @Override
    public ShapelessCraftingRecipe.Builder.EndStep group(@Nullable String name) {
        this.group = name;
        return this;
    }

    @Override
    public ShapelessCraftingRecipe.Builder.EndStep pack(DataPack<RecipeRegistration> pack) {
        this.pack = pack;
        return this;
    }

    @Override
    public RecipeRegistration build0() {
        Preconditions.checkState(!this.ingredients.isEmpty(), "The ingredients are not set.");
        return new SpongeShapelessCraftingRecipeRegistration((ResourceLocation)this.key, this.group, (List<Ingredient>)this.ingredients, ItemStackUtil.toNative(this.result), this.resultFunction, this.remainingItemsFunction, this.pack, this.recipeCategory, this.craftingBookCategory);
    }

    @Override
    public ShapelessCraftingRecipe.Builder reset() {
        super.reset();
        this.result = null;
        this.resultFunction = null;
        this.ingredients.clear();
        this.group = null;
        this.remainingItemsFunction = null;
        this.pack = DataPacks.RECIPE;
        return this;
    }
}

