/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.ingredient;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.text.MessageFormat;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.SpongeCommon;

public final class IngredientResultUtil {
    private static final Map<String, Function<?, ItemStack>> cachedResultFunctions = new Object2ObjectOpenHashMap();
    private static final Map<String, Function<?, NonNullList<ItemStack>>> cachedRemainingItemsFunctions = new Object2ObjectOpenHashMap();
    public static final Codec<String> CACHED_RESULT_FUNC_CODEC = Codec.STRING.flatXmap(id -> IngredientResultUtil.cachedResultFunction(id) != null ? DataResult.success((Object)id) : DataResult.error(() -> "Missing Result Function for id " + id), DataResult::success);
    public static final Codec<String> CACHED_REMAINING_FUNC_CODEC = Codec.STRING.flatXmap(id -> IngredientResultUtil.cachedRemainingItemsFunction(id) != null ? DataResult.success((Object)id) : DataResult.error(() -> "Missing Result Function for id " + id), DataResult::success);

    public static JsonElement serializeItemStack(ItemStack spongeResult) {
        DataResult encoded = ItemStack.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)spongeResult);
        return (JsonElement)encoded.result().get();
    }

    public static <C extends Container> @Nullable Function<C, ItemStack> cachedResultFunction(String id) {
        return cachedResultFunctions.get(id);
    }

    public static <C extends Container> String cacheResultFunction(ResourceLocation id, Function<C, ItemStack> resultFunction) {
        if (cachedResultFunctions.put(id.toString(), resultFunction) != null) {
            SpongeCommon.logger().warn(MessageFormat.format("Duplicate cache result registration! " + id + " was replaced.", new Object[0]));
        }
        return id.toString();
    }

    public static <C extends Container> @Nullable Function<C, NonNullList<ItemStack>> cachedRemainingItemsFunction(String id) {
        return cachedRemainingItemsFunctions.get(id);
    }

    public static <C extends Container> String cacheRemainingItemsFunction(ResourceLocation id, Function<C, NonNullList<ItemStack>> resultFunction) {
        if (cachedRemainingItemsFunctions.put(id.toString(), resultFunction) != null) {
            SpongeCommon.logger().warn(MessageFormat.format("Duplicate cache result registration! " + id + " was replaced.", new Object[0]));
        }
        return id.toString();
    }

    public static void clearCache() {
        cachedResultFunctions.clear();
        cachedRemainingItemsFunctions.clear();
    }
}

