/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.ingredient;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.NotImplementedException;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.item.recipe.ingredient.SpongeItemList;
import org.spongepowered.common.item.recipe.ingredient.SpongePredicateItemList;
import org.spongepowered.common.item.recipe.ingredient.SpongeStackItemList;
import org.spongepowered.common.item.util.ItemStackUtil;

public class SpongeIngredient
extends Ingredient {
    private static final Codec<ItemStack> LEGACY_STACK_CODEC = RecordCodecBuilder.create(b -> b.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("ItemType").forGetter(ItemStack::getItem), (App)Codec.INT.fieldOf("Count").forGetter(ItemStack::getCount)).apply((Applicative)b, (type, qty) -> {
        SpongeCommon.logger().info("Found legacy recipe");
        return new ItemStack((ItemLike)type, qty.intValue());
    }));
    private static final Codec<ItemStack> STACK_CODEC = ExtraCodecs.xor((Codec)ItemStack.CODEC, LEGACY_STACK_CODEC).xmap(to -> (ItemStack)to.map(i -> i, i -> i), Either::left);
    private static final Codec<SpongeRawIngredient> RAW_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ExtraCodecs.strictOptionalField((Codec)Codec.STRING, (String)"sponge:type", (Object)"vanilla").forGetter(raw -> raw.type), (App)ExtraCodecs.strictOptionalField((Codec)Codec.list(STACK_CODEC), (String)"sponge:item", List.of()).forGetter(raw -> raw.stacks), (App)ExtraCodecs.strictOptionalField((Codec)Codec.STRING, (String)"sponge:predicate").forGetter(raw -> raw.predicateId)).apply((Applicative)builder, SpongeRawIngredient::new));
    public static final Codec<SpongeIngredient> CODEC = RAW_CODEC.flatXmap(raw -> {
        switch (raw.type) {
            case "vanilla": {
                return DataResult.error(() -> "Vanilla Ingredient");
            }
            case "sponge:stack": {
                SpongeStackItemList spongeStackItemList = new SpongeStackItemList(raw.stacks.toArray(new ItemStack[0]));
                SpongeIngredient ingredient = new SpongeIngredient(raw.type, spongeStackItemList, null);
                return DataResult.success((Object)((Object)ingredient));
            }
            case "sponge:predicate": {
                if (raw.predicateId.isEmpty()) {
                    return DataResult.error(() -> "Missing sponge:predicate for custom ingredient of type " + raw.type);
                }
                Predicate<ItemStack> predicate = SpongeIngredient.cachedPredicate(raw.predicateId.get());
                if (predicate == null) {
                    return DataResult.error(() -> "Could not find predicate for custom ingredient with id " + raw.predicateId.get());
                }
                SpongeIngredient ingredient = new SpongeIngredient(raw.type, new SpongePredicateItemList(raw.predicateId.get(), predicate, raw.stacks.toArray(new ItemStack[0])), (String)raw.predicateId.orElse(null));
                return DataResult.success((Object)((Object)ingredient));
            }
        }
        return DataResult.error(() -> "Unknown ingredient type " + raw.type);
    }, spongeIngredient -> {
        switch (spongeIngredient.type) {
            case "sponge:stack": {
                List<ItemStack> stacks = Arrays.stream(spongeIngredient.values).flatMap(v -> v.getItems().stream()).toList();
                return DataResult.success((Object)new SpongeRawIngredient(spongeIngredient.type, stacks, Optional.empty()));
            }
            case "sponge:predicate": {
                return DataResult.success((Object)new SpongeRawIngredient(spongeIngredient.type, List.of(), Optional.ofNullable(spongeIngredient.predicateId)));
            }
        }
        throw new NotImplementedException("Serializing SpongeIngredient is not implemented yet.");
    });
    public final String type;
    public final String predicateId;
    private static final Map<String, Predicate<ItemStack>> cachedPredicates = new HashMap<String, Predicate<ItemStack>>();

    public SpongeIngredient(String type, Stream<? extends Ingredient.Value> values, String predicateId) {
        super(values);
        this.type = type;
        this.predicateId = predicateId;
    }

    public SpongeIngredient(String type, Ingredient.Value value, String predicateId) {
        this(type, Stream.of(value), predicateId);
    }

    public static void clearCache() {
        cachedPredicates.clear();
    }

    public boolean test(ItemStack testStack) {
        if (testStack == null) {
            return false;
        }
        for (Ingredient.Value acceptedItem : this.values) {
            if (acceptedItem instanceof SpongeItemList) {
                if (!((SpongeItemList)acceptedItem).test(testStack)) continue;
                return true;
            }
            for (ItemStack stack : acceptedItem.getItems()) {
                if (stack.getItem() != testStack.getItem()) continue;
                return true;
            }
        }
        return false;
    }

    public static SpongeIngredient spongeFromStacks(ItemStack ... stacks) {
        SpongeStackItemList itemList = new SpongeStackItemList(stacks);
        return new SpongeIngredient("sponge:stack", itemList, null);
    }

    public static SpongeIngredient spongeFromPredicate(ResourceKey key, Predicate<org.spongepowered.api.item.inventory.ItemStack> predicate, ItemStack ... exemplaryIngredients) {
        Predicate<ItemStack> mcPredicate = stack -> predicate.test(ItemStackUtil.fromNative(stack));
        Predicate<ItemStack> registeredPredicate = cachedPredicates.get(key.toString());
        if (registeredPredicate instanceof WrappedPredicate) {
            WrappedPredicate wrapped = (WrappedPredicate)registeredPredicate;
            wrapped.setPredicate(mcPredicate);
        } else if (registeredPredicate != null) {
            SpongeCommon.logger().warn(MessageFormat.format("Predicate ingredient registered twice! {} was replaced.", key.toString()));
        } else {
            cachedPredicates.put(key.toString(), mcPredicate);
        }
        SpongePredicateItemList itemList = new SpongePredicateItemList(key.toString(), mcPredicate, exemplaryIngredients);
        return new SpongeIngredient("sponge:predicate", itemList, key.toString());
    }

    public static Predicate<ItemStack> cachedPredicate(String id) {
        return cachedPredicates.computeIfAbsent(id, k -> new WrappedPredicate(id));
    }

    public static class WrappedPredicate
    implements Predicate<ItemStack> {
        private final String key;
        private Predicate<ItemStack> predicate;

        public WrappedPredicate(String key) {
            this.key = key;
        }

        public void setPredicate(Predicate<ItemStack> predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean test(ItemStack itemStack) {
            if (this.predicate == null) {
                throw new IllegalStateException(this.key + " predicate was not registered. Is the plugin loaded?");
            }
            return this.predicate.test(itemStack);
        }
    }

    record SpongeRawIngredient(String type, List<ItemStack> stacks, Optional<String> predicateId) {
    }
}

