/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.smithing;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import org.spongepowered.common.bridge.world.item.crafting.RecipeResultBridge;
import org.spongepowered.common.bridge.world.item.crafting.SmithingRecipeBridge;
import org.spongepowered.common.item.recipe.ResultFunctionRecipe;
import org.spongepowered.common.item.recipe.ingredient.IngredientResultUtil;

public class SpongeSmithingRecipe
extends SmithingTransformRecipe
implements ResultFunctionRecipe {
    public static final MapCodec<SpongeSmithingRecipe> SPONGE_CODEC = RecordCodecBuilder.mapCodec($$0 -> $$0.group((App)Codec.STRING.fieldOf("sponge:type").forGetter(a -> "custom"), (App)Ingredient.CODEC.fieldOf("template").forGetter($$0x -> ((SmithingRecipeBridge)((Object)$$0x)).bridge$template()), (App)Ingredient.CODEC.fieldOf("base").forGetter($$0x -> ((SmithingRecipeBridge)((Object)$$0x)).bridge$base()), (App)Ingredient.CODEC.fieldOf("addition").forGetter($$0x -> ((SmithingRecipeBridge)((Object)$$0x)).bridge$addition()), (App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("result").forGetter($$0x -> ((RecipeResultBridge)((Object)$$0x)).bridge$result()), (App)ItemStack.CODEC.optionalFieldOf("sponge:result", (Object)ItemStack.EMPTY).forGetter($$0x -> ((RecipeResultBridge)((Object)$$0x)).bridge$spongeResult()), (App)IngredientResultUtil.CACHED_RESULT_FUNC_CODEC.optionalFieldOf("sponge:result_function").forGetter(ResultFunctionRecipe::resultFunctionId)).apply((Applicative)$$0, SpongeSmithingRecipe::of));
    private final String resultFunctionId;

    public static SpongeSmithingRecipe of(String spongeType, Ingredient template, Ingredient base, Ingredient addition, ItemStack resultIn, ItemStack spongeResult, Optional<String> resultFunctionId) {
        return new SpongeSmithingRecipe(template, base, addition, spongeResult.isEmpty() ? resultIn : spongeResult, resultFunctionId.orElse(null));
    }

    public SpongeSmithingRecipe(Ingredient template, Ingredient base, Ingredient addition, ItemStack spongeResult, String resultFunctionId) {
        super(template, base, addition, spongeResult);
        this.resultFunctionId = resultFunctionId;
    }

    @Override
    public Optional<String> resultFunctionId() {
        return Optional.ofNullable(this.resultFunctionId);
    }

    public ItemStack assemble(Container $$0, RegistryAccess $$1) {
        if (this.resultFunctionId != null) {
            return IngredientResultUtil.cachedResultFunction(this.resultFunctionId).apply($$0);
        }
        if (this.getResultItem($$1).hasTag()) {
            ItemStack itemStack = this.getResultItem($$1).copy();
            CompoundTag compoundnbt = $$0.getItem(0).getTag();
            if (compoundnbt != null) {
                CompoundTag merged = itemStack.getTag().merge(compoundnbt.copy());
                itemStack.setTag(merged);
                return itemStack;
            }
        }
        return super.assemble($$0, $$1);
    }

    public ItemStack getResultItem(RegistryAccess $$1) {
        if (this.resultFunctionId != null) {
            return ItemStack.EMPTY;
        }
        return super.getResultItem($$1);
    }
}

