/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.smithing;

import java.util.List;
import java.util.function.Function;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.item.recipe.Recipe;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.api.item.recipe.smithing.SmithingRecipe;
import org.spongepowered.common.item.recipe.SpongeRecipeRegistration;
import org.spongepowered.common.item.recipe.smithing.SpongeSmithingRecipe;

public class SpongeSmithingRecipeRegistration
extends SpongeRecipeRegistration<SmithingTransformRecipe>
implements SpongeRecipeRegistration.ResultFunctionRegistration<Container> {
    private final Ingredient template;
    private final Ingredient base;
    private final Ingredient addition;
    private final ItemStack spongeResult;
    private final Function<Container, ItemStack> resultFunction;

    public SpongeSmithingRecipeRegistration(ResourceLocation key, String group, Ingredient template, Ingredient base, Ingredient addition, ItemStack spongeResult, Function<Container, ItemStack> resultFunction, DataPack<RecipeRegistration> pack, RecipeCategory category) {
        super(key, group, pack, category, RecipeSerializer.SMITHING_TRANSFORM);
        this.template = template;
        this.base = base;
        this.addition = addition;
        this.spongeResult = spongeResult;
        this.resultFunction = resultFunction;
    }

    @Override
    public Recipe recipe() {
        this.ensureCached();
        if (SpongeRecipeRegistration.isVanillaSerializer(this.spongeResult, this.resultFunction, null, List.of(this.template, this.base, this.addition))) {
            return (SmithingRecipe)new SmithingTransformRecipe(this.template, this.base, this.addition, this.spongeResult);
        }
        return (SmithingRecipe)((Object)new SpongeSmithingRecipe(this.template, this.base, this.addition, this.spongeResult, this.resultFunction == null ? null : this.key.toString()));
    }

    @Override
    public Function<Container, ItemStack> resultFunction() {
        return this.resultFunction;
    }
}

