/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.stonecutting;

import java.util.Collections;
import java.util.function.Function;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.item.recipe.Recipe;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.api.item.recipe.single.StoneCutterRecipe;
import org.spongepowered.common.item.recipe.SpongeRecipeRegistration;
import org.spongepowered.common.item.recipe.stonecutting.SpongeStonecuttingRecipe;

public class SpongeStonecuttingRecipeRegistration
extends SpongeRecipeRegistration<StonecutterRecipe>
implements SpongeRecipeRegistration.ResultFunctionRegistration<Container> {
    private final Ingredient ingredient;
    private final ItemStack spongeResult;
    private Function<Container, ItemStack> resultFunction;

    public SpongeStonecuttingRecipeRegistration(ResourceLocation key, String group, Ingredient ingredient, ItemStack spongeResult, Function<Container, ItemStack> resultFunction, DataPack<RecipeRegistration> pack, RecipeCategory category) {
        super(key, group, pack, category, RecipeSerializer.STONECUTTER);
        this.ingredient = ingredient;
        this.spongeResult = spongeResult;
        this.resultFunction = resultFunction;
    }

    @Override
    public Recipe recipe() {
        this.ensureCached();
        if (SpongeRecipeRegistration.isVanillaSerializer(this.spongeResult, this.resultFunction, null, Collections.singleton(this.ingredient))) {
            return (StoneCutterRecipe)new StonecutterRecipe(this.group, this.ingredient, this.spongeResult);
        }
        return (StoneCutterRecipe)((Object)new SpongeStonecuttingRecipe(this.group, this.ingredient, this.spongeResult, this.resultFunction == null ? null : this.key.toString()));
    }

    @Override
    public Function<Container, ItemStack> resultFunction() {
        return this.resultFunction;
    }
}

