/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.advancements;

import java.time.Instant;
import java.util.Optional;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.resources.ResourceLocation;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.AdvancementProgress;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.advancements.AdvancementProgressBridge;
import org.spongepowered.common.bridge.advancements.CriterionProgressBridge;

@Mixin(value={CriterionProgress.class})
public abstract class CriterionProgressMixin_API
implements org.spongepowered.api.advancement.criteria.CriterionProgress {
    @Shadow
    private @Nullable Instant obtained;

    @Override
    public AdvancementCriterion criterion() {
        return ((CriterionProgressBridge)((Object)this)).bridge$getCriterion();
    }

    @Override
    public boolean achieved() {
        return this.obtained != null;
    }

    @Override
    public Optional<Instant> get() {
        return this.obtained == null ? Optional.empty() : Optional.of(this.obtained);
    }

    @Override
    public Instant grant() {
        if (this.obtained != null) {
            return this.obtained;
        }
        AdvancementProgress advancementProgress = ((CriterionProgressBridge)((Object)this)).bridge$getAdvancementProgress();
        ResourceLocation key = ((AdvancementProgressBridge)((Object)advancementProgress)).bridge$getAdvancementKey();
        Advancement advancement = advancementProgress.advancement();
        AdvancementHolder holder = new AdvancementHolder(key, (net.minecraft.advancements.Advancement)advancement);
        ((AdvancementProgressBridge)((Object)advancementProgress)).bridge$getPlayerAdvancements().award(holder, this.criterion().name());
        return this.obtained;
    }

    @Override
    public Optional<Instant> revoke() {
        if (this.obtained == null) {
            return Optional.empty();
        }
        Instant instant = this.obtained;
        AdvancementProgress advancementProgress = ((CriterionProgressBridge)((Object)this)).bridge$getAdvancementProgress();
        ResourceLocation key = ((AdvancementProgressBridge)((Object)advancementProgress)).bridge$getAdvancementKey();
        Advancement advancement = advancementProgress.advancement();
        AdvancementHolder holder = new AdvancementHolder(key, (net.minecraft.advancements.Advancement)advancement);
        ((AdvancementProgressBridge)((Object)advancementProgress)).bridge$getPlayerAdvancements().revoke(holder, this.criterion().name());
        return Optional.of(instant);
    }
}

