/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.damagesource;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.cause.entity.damage.DamageType;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.world.damagesource.DamageSourceBridge;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={DamageSource.class})
public abstract class DamageSourceMixin_API
implements org.spongepowered.api.event.cause.entity.damage.source.DamageSource {
    @Shadow
    @Final
    private @Nullable net.minecraft.world.entity.Entity directEntity;
    @Shadow
    @Final
    private @Nullable net.minecraft.world.entity.Entity causingEntity;
    @Shadow
    @Final
    private Holder<net.minecraft.world.damagesource.DamageType> type;
    @Shadow
    @Final
    private @Nullable Vec3 damageSourcePosition;

    @Override
    public Optional<Entity> source() {
        return Optional.ofNullable((Entity)this.directEntity);
    }

    @Override
    public Optional<Entity> indirectSource() {
        return Optional.ofNullable((Entity)this.causingEntity);
    }

    @Override
    public boolean doesAffectCreative() {
        return false;
    }

    @Override
    public Optional<ServerLocation> location() {
        return Optional.ofNullable(((DamageSourceBridge)((Object)this)).bridge$blockLocation());
    }

    @Override
    public Optional<BlockSnapshot> blockSnapshot() {
        return Optional.ofNullable(((DamageSourceBridge)((Object)this)).bridge$blockSnapshot());
    }

    @Override
    public Optional<Vector3d> position() {
        return Optional.ofNullable(VecHelper.toVector3d(this.damageSourcePosition));
    }

    @Override
    public DamageType type() {
        return (DamageType)this.type.value();
    }
}

