/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.item;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.item.ItemRarity;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.registry.DefaultedRegistryType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.tag.Tag;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.data.holder.SpongeImmutableDataHolder;

@Mixin(value={Item.class})
public abstract class ItemMixin_API
implements ItemType,
SpongeImmutableDataHolder<ItemType> {
    @Shadow
    @Final
    private Rarity rarity;
    @Shadow
    @Final
    private Holder.Reference<Item> builtInRegistryHolder;
    protected @Nullable BlockType api$blockType = null;

    @Shadow
    public abstract int shadow$getMaxStackSize();

    @Shadow
    public abstract String shadow$getDescriptionId();

    @Shadow
    public abstract @Nullable Item shadow$getCraftingRemainingItem();

    public Component asComponent() {
        return Component.translatable((String)this.shadow$getDescriptionId());
    }

    @Override
    public int maxStackQuantity() {
        return this.shadow$getMaxStackSize();
    }

    @Override
    public ItemRarity rarity() {
        return (ItemRarity)this.rarity;
    }

    @Override
    public Optional<BlockType> block() {
        return Optional.ofNullable(this.api$blockType);
    }

    @Override
    public boolean isAnyOf(Supplier<? extends ItemType> ... types) {
        return Arrays.stream(types).map(Supplier::get).anyMatch(type -> type == this);
    }

    @Override
    public boolean isAnyOf(ItemType ... types) {
        return Arrays.stream(types).anyMatch(type -> type == this);
    }

    @Override
    public DefaultedRegistryType<ItemType> registryType() {
        return RegistryTypes.ITEM_TYPE;
    }

    @Override
    public Collection<Tag<ItemType>> tags() {
        return this.registryType().get().tags().filter(this::is).collect(Collectors.toSet());
    }

    @Override
    public boolean is(Tag<ItemType> tag) {
        return this.builtInRegistryHolder.is((TagKey)tag);
    }

    @Override
    public Optional<ItemType> container() {
        Item craftingRemainingItem = this.shadow$getCraftingRemainingItem();
        return Optional.ofNullable((ItemType)craftingRemainingItem);
    }
}

