/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.item;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.SerializableDataHolder;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.entity.attribute.AttributeModifier;
import org.spongepowered.api.entity.attribute.type.AttributeType;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.item.SpongeItemStackSnapshot;
import org.spongepowered.common.util.Constants;

@Mixin(value={ItemStack.class})
@Implements(value={@Interface(iface=org.spongepowered.api.item.inventory.ItemStack.class, prefix="itemStack$", remap=Interface.Remap.NONE)})
public abstract class ItemStackMixin_API
implements SerializableDataHolder.Mutable,
ComponentLike,
HoverEventSource<HoverEvent.ShowItem> {
    @Shadow
    @Final
    private static Logger LOGGER;

    @Shadow
    public abstract int shadow$getCount();

    @Shadow
    public abstract void shadow$setCount(int var1);

    @Shadow
    public abstract void shadow$setDamageValue(int var1);

    @Shadow
    public abstract void shadow$setTag(@Nullable CompoundTag var1);

    @Shadow
    public abstract int shadow$getDamageValue();

    @Shadow
    public abstract int shadow$getMaxStackSize();

    @Shadow
    public abstract boolean shadow$hasTag();

    @Shadow
    public abstract boolean shadow$isEmpty();

    @Shadow
    public abstract CompoundTag shadow$getTag();

    @Shadow
    public abstract ItemStack shadow$copy();

    @Shadow
    public abstract Item shadow$getItem();

    @Shadow
    public abstract Multimap<Attribute, net.minecraft.world.entity.ai.attributes.AttributeModifier> shadow$getAttributeModifiers(EquipmentSlot var1);

    @Shadow
    public abstract void shadow$addAttributeModifier(Attribute var1, net.minecraft.world.entity.ai.attributes.AttributeModifier var2, @Nullable EquipmentSlot var3);

    @Shadow
    public abstract String shadow$getDescriptionId();

    @Shadow
    public abstract net.minecraft.network.chat.Component shadow$getDisplayName();

    public int itemStack$quantity() {
        return this.shadow$getCount();
    }

    public ItemType itemStack$type() {
        return (ItemType)this.shadow$getItem();
    }

    public void itemStack$setQuantity(int quantity) throws IllegalArgumentException {
        this.shadow$setCount(quantity);
    }

    public int itemStack$maxStackQuantity() {
        return this.shadow$getMaxStackSize();
    }

    @Override
    public boolean validateRawData(DataView container) {
        Objects.requireNonNull(container);
        return false;
    }

    @Override
    public void setRawData(DataView container) throws InvalidDataException {
        Objects.requireNonNull(container);
        if (this.shadow$isEmpty()) {
            throw new IllegalArgumentException("Cannot set data on empty item stacks!");
        }
        if (!container.contains(Constants.Sponge.UNSAFE_NBT)) {
            throw new InvalidDataException("There's no NBT Data set in the provided container");
        }
        DataView nbtData = container.getView(Constants.Sponge.UNSAFE_NBT).get();
        try {
            int integer = container.getInt(Constants.ItemStack.DAMAGE_VALUE).orElse(this.shadow$getDamageValue());
            this.shadow$setDamageValue(integer);
            CompoundTag stackCompound = NBTTranslator.INSTANCE.translate(nbtData);
            this.shadow$setTag(stackCompound);
        }
        catch (Exception e) {
            throw new InvalidDataException("Unable to set raw data or translate raw data for ItemStack setting", e);
        }
    }

    @Override
    public SerializableDataHolder.Mutable copy() {
        return this.itemStack$copy();
    }

    public org.spongepowered.api.item.inventory.ItemStack itemStack$copy() {
        return (org.spongepowered.api.item.inventory.ItemStack)this.shadow$copy();
    }

    public Collection<AttributeModifier> itemStack$attributeModifiers(AttributeType attributeType, EquipmentType equipmentType) {
        Objects.requireNonNull(attributeType, "Attribute type cannot be null");
        Objects.requireNonNull(equipmentType, "Equipment type cannot be null");
        ImmutableList.Builder builder = ImmutableList.builder();
        Multimap<Attribute, net.minecraft.world.entity.ai.attributes.AttributeModifier> modifierMultimap = this.shadow$getAttributeModifiers((EquipmentSlot)equipmentType);
        builder.addAll((Iterable)modifierMultimap.get((Object)((Attribute)attributeType)));
        return builder.build();
    }

    public void itemStack$addAttributeModifier(AttributeType attributeType, AttributeModifier modifier, EquipmentType equipmentType) {
        Objects.requireNonNull(attributeType, "Attribute type cannot be null");
        Objects.requireNonNull(modifier, "Attribute modifier cannot be null");
        Objects.requireNonNull(equipmentType, "Equipment type cannot be null");
        this.shadow$addAttributeModifier((Attribute)attributeType, (net.minecraft.world.entity.ai.attributes.AttributeModifier)modifier, (EquipmentSlot)equipmentType);
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        ResourceKey key = (ResourceKey)SpongeCommon.vanillaRegistry(Registries.ITEM).getKey((Object)((Item)this.itemStack$type()));
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, this.contentVersion()).set(Constants.ItemStack.TYPE, key).set(Constants.ItemStack.COUNT, this.itemStack$quantity()).set(Constants.ItemStack.DAMAGE_VALUE, this.shadow$getDamageValue());
        if (this.shadow$hasTag()) {
            CompoundTag spongeCompound;
            CompoundTag compound = this.shadow$getTag().copy();
            if (compound.contains("SpongeData") && (spongeCompound = compound.getCompound("SpongeData")).contains("CustomManipulators")) {
                spongeCompound.remove("CustomManipulators");
            }
            Constants.NBT.filterSpongeCustomData(compound);
            if (!compound.isEmpty()) {
                DataContainer unsafeNbt = NBTTranslator.INSTANCE.translateFrom(compound);
                container.set(Constants.Sponge.UNSAFE_NBT, unsafeNbt);
            }
        }
        try {
            PlatformHooks.INSTANCE.getItemHooks().writeItemStackCapabilitiesToDataView(container, (ItemStack)this);
        }
        catch (Exception e) {
            LOGGER.error("Failed to write capabilities to data view", (Throwable)e);
        }
        return container;
    }

    public ItemStackSnapshot itemStack$createSnapshot() {
        return new SpongeItemStackSnapshot((org.spongepowered.api.item.inventory.ItemStack)((Object)this));
    }

    public boolean itemStack$equalTo(org.spongepowered.api.item.inventory.ItemStack that) {
        return ItemStack.matches((ItemStack)((ItemStack)this), (ItemStack)((ItemStack)that));
    }

    @Intrinsic
    public boolean itemStack$isEmpty() {
        return this.shadow$isEmpty();
    }

    public Component asComponent() {
        return SpongeAdventure.asAdventure(this.shadow$getDisplayName());
    }

    public @NonNull HoverEvent<// Could not load outer class - annotation placement on inner may be incorrect
    HoverEvent.ShowItem> asHoverEvent(@NonNull UnaryOperator<// Could not load outer class - annotation placement on inner may be incorrect
    HoverEvent.ShowItem> op) {
        HoverEvent.ShowItem event = HoverEvent.ShowItem.of((Key)SpongeAdventure.asAdventure(SpongeCommon.vanillaRegistry(Registries.ITEM).getKey((Object)this.shadow$getItem())), (int)this.shadow$getCount(), (BinaryTagHolder)SpongeAdventure.asBinaryTagHolder(this.shadow$getTag()));
        return HoverEvent.showItem((HoverEvent.ShowItem)((HoverEvent.ShowItem)Objects.requireNonNull(op, "op").apply(event)));
    }
}

