/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.item.crafting;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.RecipeType;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.inventory.util.InventoryUtil;
import org.spongepowered.common.item.recipe.ingredient.IngredientUtil;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={Recipe.class})
public interface RecipeMixin_API<C extends Container>
extends org.spongepowered.api.item.recipe.Recipe {
    @Shadow
    public ItemStack shadow$assemble(C var1, RegistryAccess var2);

    @Shadow
    public ItemStack shadow$getResultItem(RegistryAccess var1);

    @Shadow
    public boolean shadow$isSpecial();

    @Shadow
    public boolean shadow$matches(C var1, Level var2);

    @Shadow
    public NonNullList<ItemStack> shadow$getRemainingItems(C var1);

    @Shadow
    public net.minecraft.world.item.crafting.RecipeType<?> shadow$getType();

    @Shadow
    public NonNullList<Ingredient> shadow$getIngredients();

    @Override
    default public @NonNull ItemStackSnapshot exemplaryResult() {
        return ItemStackUtil.snapshotOf(this.shadow$getResultItem((RegistryAccess)SpongeCommon.server().registryAccess()));
    }

    @Override
    default public boolean isValid(@NonNull Inventory inv, @NonNull ServerWorld world) {
        return this.shadow$matches(InventoryUtil.toNativeInventory(inv), (Level)world);
    }

    @Override
    default public @NonNull ItemStackSnapshot result(@NonNull Inventory inv) {
        return ItemStackUtil.snapshotOf(this.shadow$assemble(InventoryUtil.toNativeInventory(inv), (RegistryAccess)SpongeCommon.server().registryAccess()));
    }

    @Override
    default public @NonNull List<ItemStackSnapshot> remainingItems(@NonNull Inventory inv) {
        return this.shadow$getRemainingItems(InventoryUtil.toNativeInventory(inv)).stream().map(ItemStackUtil::snapshotOf).collect(Collectors.toList());
    }

    @Override
    default public List<org.spongepowered.api.item.recipe.crafting.Ingredient> ingredients() {
        return this.shadow$getIngredients().stream().map(IngredientUtil::fromNative).collect(Collectors.toList());
    }

    @Override
    default public boolean isDynamic() {
        return this.shadow$isSpecial();
    }

    @Override
    default public RecipeType<? extends org.spongepowered.api.item.recipe.Recipe> type() {
        return (RecipeType)this.shadow$getType();
    }
}

