/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.biome;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.world.biome.provider.CheckerboardBiomeConfig;
import org.spongepowered.api.world.biome.provider.ConfigurableBiomeProvider;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.mixin.api.minecraft.world.level.biome.BiomeSourceMixin_API;

@Mixin(value={CheckerboardColumnBiomeSource.class})
public abstract class CheckerboardColumnBiomeSourceMixin_API
extends BiomeSourceMixin_API
implements ConfigurableBiomeProvider<CheckerboardBiomeConfig> {
    @Shadow
    @Final
    private HolderSet<Biome> allowedBiomes;
    @Shadow
    @Final
    private int size;
    private @Nullable CheckerboardBiomeConfig api$config;

    @Override
    public CheckerboardBiomeConfig config() {
        if (this.api$config == null) {
            Registry biomeRegistry = SpongeCommon.vanillaRegistry(Registries.BIOME);
            List<RegistryReference<org.spongepowered.api.world.biome.Biome>> biomes = this.allowedBiomes.stream().map(Holder::value).map(biome -> RegistryTypes.BIOME.referenced((ResourceKey)biomeRegistry.getKey(biome))).collect(Collectors.toList());
            this.api$config = (CheckerboardBiomeConfig)CheckerboardBiomeConfig.builder().addBiomes(biomes).scale(this.size).build();
        }
        return this.api$config;
    }
}

