/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.levelgen.carver;

import com.google.gson.JsonElement;
import java.io.IOException;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.world.generation.carver.Carver;
import org.spongepowered.api.world.generation.carver.CarverType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.world.generation.carver.SpongeCarverTemplate;

@Mixin(value={ConfiguredWorldCarver.class})
public abstract class ConfiguredWorldCarverMixin_API<WC extends CarverConfiguration>
implements Carver {
    @Shadow
    @Final
    private WorldCarver<WC> worldCarver;
    @Shadow
    @Final
    private WC config;

    @Override
    public CarverType type() {
        return (CarverType)this.worldCarver;
    }

    @Override
    public DataView toContainer() {
        JsonElement serialized = SpongeCarverTemplate.encode(this.worldCarver.configuredCodec(), (ConfiguredWorldCarver)this, (RegistryAccess)SpongeCommon.server().registryAccess());
        try {
            return DataFormats.JSON.get().read(serialized.toString());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read deserialized Carver: " + serialized, e);
        }
    }
}

