/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.advancements;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.advancement.criteria.AndCriterion;
import org.spongepowered.api.advancement.criteria.OrCriterion;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.advancement.criterion.DefaultedAdvancementCriterion;
import org.spongepowered.common.advancement.criterion.SpongeScoreCriterion;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.advancements.AdvancementBridge;
import org.spongepowered.common.bridge.advancements.CriterionBridge;
import org.spongepowered.common.bridge.advancements.DisplayInfoBridge;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.util.Preconditions;

@Mixin(value={net.minecraft.advancements.Advancement.class})
public abstract class AdvancementMixin
implements AdvancementBridge {
    @Shadow
    @Final
    private Optional<DisplayInfo> display;
    private AdvancementCriterion impl$criterion;
    private List<Component> impl$toastText;

    @Inject(method={"<init>(Ljava/util/Optional;Ljava/util/Optional;Lnet/minecraft/advancements/AdvancementRewards;Ljava/util/Map;Lnet/minecraft/advancements/AdvancementRequirements;Z)V"}, at={@At(value="RETURN")})
    private void impl$setUpSpongeFields(Optional<ResourceLocation> parent, Optional<DisplayInfo> displayInfo, AdvancementRewards $$2, Map<String, Criterion<?>> criteria, AdvancementRequirements requirements, boolean sendsTelemetryEvent, CallbackInfo ci) {
        if (!PlatformHooks.INSTANCE.getGeneralHooks().onServerThread()) {
            return;
        }
        displayInfo.ifPresent(info -> ((DisplayInfoBridge)info).bridge$setAdvancement((Advancement)((Object)this)));
        this.impl$toastText = this.impl$generateToastText();
        LinkedHashMap<String, DefaultedAdvancementCriterion> criteriaMap = new LinkedHashMap<String, DefaultedAdvancementCriterion>();
        HashMap<String, List> scoreCriteria = new HashMap<String, List>();
        for (Map.Entry<String, Criterion<?>> entry : criteria.entrySet()) {
            CriterionBridge mixinCriterion = (CriterionBridge)entry.getValue();
            String groupName = mixinCriterion.bridge$getScoreCriterionName();
            if (groupName != null) {
                scoreCriteria.computeIfAbsent(groupName, k -> new ArrayList()).add((DefaultedAdvancementCriterion)entry.getValue());
            }
            criteriaMap.put(entry.getKey(), (DefaultedAdvancementCriterion)((Object)mixinCriterion));
            mixinCriterion.bridge$setName(entry.getKey());
        }
        for (Map.Entry<String, Object> entry : scoreCriteria.entrySet()) {
            criteriaMap.put(entry.getKey(), new SpongeScoreCriterion(entry.getKey(), (List)entry.getValue()));
            ((List)entry.getValue()).forEach(c -> criteriaMap.remove(c.name()));
        }
        HashSet<AdvancementCriterion> andCriteria = new HashSet<AdvancementCriterion>();
        for (List array : requirements.requirements()) {
            HashSet<AdvancementCriterion> orCriteria = new HashSet<AdvancementCriterion>();
            for (String name : array) {
                DefaultedAdvancementCriterion criterion = (DefaultedAdvancementCriterion)criteriaMap.get(name);
                if (criterion == null && criteria.get(name) != null) {
                    criterion = (DefaultedAdvancementCriterion)criteriaMap.get(((CriterionBridge)criteria.get(name)).bridge$getScoreCriterionName());
                }
                if (criterion == null) continue;
                orCriteria.add(criterion);
            }
            andCriteria.add(OrCriterion.of(orCriteria));
        }
        this.impl$criterion = AndCriterion.of(andCriteria);
    }

    private ImmutableList<Component> impl$generateToastText() {
        ImmutableList.Builder toastText = ImmutableList.builder();
        if (this.display.isPresent()) {
            AdvancementType frameType = this.display.get().getType();
            toastText.add((Object)Component.translatable((String)("advancements.toast." + frameType.getSerializedName()), (TextColor)SpongeAdventure.asAdventureNamed(frameType.getChatColor())));
            toastText.add((Object)SpongeAdventure.asAdventure(this.display.get().getTitle()));
        }
        return toastText.build();
    }

    @Override
    public AdvancementCriterion bridge$getCriterion() {
        Preconditions.checkState(PlatformHooks.INSTANCE.getGeneralHooks().onServerThread());
        return this.impl$criterion;
    }

    @Override
    public void bridge$setCriterion(AdvancementCriterion criterion) {
        this.impl$criterion = criterion;
    }

    @Override
    public List<Component> bridge$getToastText() {
        Preconditions.checkState(PlatformHooks.INSTANCE.getGeneralHooks().onServerThread());
        return this.impl$toastText;
    }
}

