/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.advancements;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.util.ExtraCodecs;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.advancement.criterion.SpongeScoreCriterion;
import org.spongepowered.common.advancement.criterion.SpongeScoreTrigger;
import org.spongepowered.common.bridge.advancements.CriterionBridge;

@Mixin(value={Criterion.class})
public abstract class CriterionMixin<T extends CriterionTriggerInstance>
implements CriterionBridge {
    @Shadow
    @Final
    private T triggerInstance;
    private @Nullable String impl$name;
    private @Nullable SpongeScoreCriterion impl$scoreCriterion;
    private @Nullable Integer impl$scoreGoal;
    private @Nullable String impl$scoreCriterionName;

    @Redirect(method={"<clinit>"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/ExtraCodecs;dispatchOptionalValue(Ljava/lang/String;Ljava/lang/String;Lcom/mojang/serialization/Codec;Ljava/util/function/Function;Ljava/util/function/Function;)Lcom/mojang/serialization/MapCodec;"))
    private static MapCodec<Criterion<?>> impl$onCodecCreation(String $$0, String $$1, Codec<CriterionTrigger<?>> $$2, Function<? super Criterion<?>, ? extends CriterionTrigger<?>> $$3, Function<? super CriterionTrigger<?>, ? extends Codec<? extends Criterion<?>>> $$4) {
        MapCodec mcCodec = ExtraCodecs.dispatchOptionalValue((String)$$0, (String)$$1, $$2, $$3, $$4);
        MapCodec triggerTimesCodec = Codec.optionalField((String)"trigger_times", (Codec)Codec.INT);
        MapCodec<Criterion<?>> tmpCodec = CriterionMixin.impl$dependent(mcCodec, triggerTimesCodec, CriterionBridge::bridge$getScoreGoal, CriterionBridge::bridge$setScoreGoal);
        MapCodec criterionCodec = Codec.optionalField((String)"criterion", (Codec)Codec.STRING);
        tmpCodec = CriterionMixin.impl$dependent(tmpCodec, criterionCodec, bridge -> bridge.bridge$getScoreCriterion() == null ? null : bridge.bridge$getScoreCriterion().name(), CriterionBridge::bridge$setScoreCriterionName);
        return tmpCodec;
    }

    private static <T> MapCodec<Criterion<?>> impl$dependent(MapCodec<Criterion<?>> original, MapCodec<Optional<T>> codec, Function<CriterionBridge, T> getter, BiConsumer<CriterionBridge, T> setter) {
        return original.dependent(codec, criterion -> Pair.of(Optional.ofNullable(getter.apply((CriterionBridge)criterion)), (Object)codec), (criterion, optValue) -> {
            optValue.ifPresent(value -> setter.accept((CriterionBridge)criterion, value));
            return criterion;
        });
    }

    @Override
    public String bridge$getName() {
        if (this.impl$name == null) {
            this.impl$name = UUID.randomUUID().toString().replace("-", "");
        }
        return this.impl$name;
    }

    @Override
    public void bridge$setName(String name) {
        this.impl$name = name;
    }

    @Override
    public @Nullable SpongeScoreCriterion bridge$getScoreCriterion() {
        return this.impl$scoreCriterion;
    }

    @Override
    public void bridge$setScoreCriterion(@Nullable SpongeScoreCriterion criterion) {
        this.impl$scoreCriterion = criterion;
    }

    @Override
    public @Nullable Integer bridge$getScoreGoal() {
        Integer n;
        T t = this.triggerInstance;
        if (t instanceof SpongeScoreTrigger.TriggerInstance) {
            SpongeScoreTrigger.TriggerInstance instance = (SpongeScoreTrigger.TriggerInstance)t;
            n = instance.triggerTimes();
        } else {
            n = null;
        }
        return n;
    }

    @Override
    public void bridge$setScoreGoal(@Nullable Integer goal) {
        this.impl$scoreGoal = goal;
    }

    @Override
    public void bridge$setScoreCriterionName(String name) {
        this.impl$scoreCriterionName = name;
    }

    @Override
    public @Nullable String bridge$getScoreCriterionName() {
        return this.impl$scoreCriterionName;
    }

    @Inject(method={"hashCode"}, at={@At(value="RETURN")}, cancellable=true)
    public void impl$onHashCode(CallbackInfoReturnable<Integer> cir) {
        int result = (Integer)cir.getReturnValue();
        result += 31 * result + this.bridge$getName().hashCode();
        cir.setReturnValue((Object)result);
    }

    @Inject(method={"equals"}, at={@At(value="RETURN")}, cancellable=true)
    public void impl$Equals(Object obj, CallbackInfoReturnable<Boolean> cir) {
        boolean result = (Boolean)cir.getReturnValue();
        result = result && ((CriterionBridge)obj).bridge$getName().equals(this.bridge$getName());
        cir.setReturnValue((Object)result);
    }
}

