/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.server.commands.AdvancementCommands;
import net.minecraft.server.level.ServerPlayer;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.commands.CommandsBridge;
import org.spongepowered.common.bridge.commands.arguments.CompletionsArgumentTypeBridge;
import org.spongepowered.common.command.brigadier.dispatcher.DelegatingCommandDispatcher;
import org.spongepowered.common.command.brigadier.dispatcher.SpongeNodePermissionCache;
import org.spongepowered.common.command.brigadier.tree.SpongeArgumentCommandNode;
import org.spongepowered.common.command.brigadier.tree.SpongeNode;
import org.spongepowered.common.command.brigadier.tree.SuggestionArgumentNode;
import org.spongepowered.common.command.manager.SpongeCommandManager;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.util.CommandUtil;

@Mixin(value={Commands.class})
public abstract class CommandsMixin
implements CommandsBridge {
    private  @MonotonicNonNull CauseStackManager.StackFrame impl$initFrame = null;
    private final WeakHashMap<ServerPlayer, Map<CommandNode<CommandSourceStack>, List<CommandNode<SharedSuggestionProvider>>>> impl$playerNodeCache = new WeakHashMap();
    private @MonotonicNonNull SpongeCommandManager impl$commandManager;

    @Shadow
    private void shadow$fillUsableCommands(CommandNode<CommandSourceStack> rootCommandSource, CommandNode<SharedSuggestionProvider> rootSuggestion, CommandSourceStack source, Map<CommandNode<CommandSourceStack>, CommandNode<SharedSuggestionProvider>> commandNodeToSuggestionNode) {
        throw new AssertionError((Object)"This shouldn't be callable");
    }

    @Redirect(method={"<init>"}, at=@At(value="NEW", args={"class=com/mojang/brigadier/CommandDispatcher"}, remap=false))
    private CommandDispatcher<CommandSourceStack> impl$useSpongeDispatcher() {
        SpongeCommandManager manager = (SpongeCommandManager)((Launch)Launch.instance()).lifecycle().platformInjector().getInstance(SpongeCommandManager.class);
        manager.init();
        this.impl$commandManager = manager;
        return new DelegatingCommandDispatcher(manager.getBrigadierRegistrar());
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/commands/AdvancementCommands;register(Lcom/mojang/brigadier/CommandDispatcher;)V"))
    private void impl$setupStackFrameOnInit(CommandDispatcher<CommandSourceStack> dispatcher) {
        this.impl$initFrame = PhaseTracker.getCauseStackManager().pushCauseFrame();
        this.impl$initFrame.pushCause(((Launch)Launch.instance()).minecraftPlugin());
        AdvancementCommands.register(dispatcher);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void impl$tellDispatcherCommandsAreRegistered(CallbackInfo ci) {
        this.impl$initFrame.popCause();
        PhaseTracker.getCauseStackManager().popCauseFrame(this.impl$initFrame);
        this.impl$initFrame = null;
    }

    @Redirect(method={"fillUsableCommands"}, slice=@Slice(from=@At(value="HEAD"), to=@At(value="INVOKE", remap=false, target="Ljava/util/Iterator;hasNext()Z")), at=@At(value="INVOKE", target="Lcom/mojang/brigadier/tree/CommandNode;getChildren()Ljava/util/Collection;", remap=false))
    private Collection<CommandNode<CommandSourceStack>> impl$handleHiddenChildrenAndEnsureUnsortedLoop(CommandNode<CommandSourceStack> commandNode) {
        return this.impl$getChildrenFromNode(commandNode);
    }

    @Redirect(method={"fillUsableCommands"}, at=@At(value="INVOKE", target="Lcom/mojang/brigadier/tree/CommandNode;createBuilder()Lcom/mojang/brigadier/builder/ArgumentBuilder;", remap=false))
    private ArgumentBuilder<?, ?> impl$createArgumentBuilder(CommandNode<CommandSourceStack> commandNode, CommandNode<CommandSourceStack> rootCommandSource, CommandNode<SharedSuggestionProvider> rootSuggestion, CommandSourceStack source, Map<CommandNode<CommandSourceStack>, CommandNode<SharedSuggestionProvider>> commandNodeToSuggestionNode) {
        ArgumentCommandNode acn;
        ArgumentType argumentType;
        if (commandNode instanceof SpongeArgumentCommandNode) {
            SpongeArgumentCommandNode node = (SpongeArgumentCommandNode)commandNode;
            return node.createBuilderForSuggestions(rootSuggestion, commandNodeToSuggestionNode);
        }
        if (commandNode instanceof ArgumentCommandNode && (argumentType = (acn = (ArgumentCommandNode)commandNode).getType()) instanceof CompletionsArgumentTypeBridge) {
            CompletionsArgumentTypeBridge catb = (CompletionsArgumentTypeBridge)argumentType;
            RequiredArgumentBuilder builder = RequiredArgumentBuilder.argument((String)acn.getName(), catb.bridge$clientSideCompletionType());
            ((RequiredArgumentBuilder)builder.executes(acn.getCommand())).forward(acn.getRedirect(), acn.getRedirectModifier(), acn.isFork()).requires(acn.getRequirement());
            if (!CommandUtil.checkForCustomSuggestions(rootSuggestion)) {
                builder.suggests(SuggestionProviders.ASK_SERVER);
            }
            return builder;
        }
        return commandNode.createBuilder();
    }

    @Redirect(method={"fillUsableCommands"}, at=@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", remap=false))
    private <K, V> V impl$preventPutIntoMapIfNodeIsComplex(Map<K, V> map, K key, V value, CommandNode<CommandSourceStack> rootCommandSource, CommandNode<SharedSuggestionProvider> rootSuggestion, CommandSourceStack source, Map<CommandNode<CommandSourceStack>, CommandNode<SharedSuggestionProvider>> commandNodeToSuggestionNode) {
        if (!map.containsKey(key)) {
            ServerPlayer e = (ServerPlayer)source.getEntity();
            Map<CommandNode<CommandSourceStack>, List<CommandNode<SharedSuggestionProvider>>> playerNodes = this.impl$playerNodeCache.get(e);
            if (!playerNodes.containsKey(key)) {
                ArrayList<CommandNode> children = new ArrayList<CommandNode>();
                children.add((CommandNode)value);
                playerNodes.put((CommandNode<CommandSourceStack>)((CommandNode)key), children);
            }
            if (value instanceof ArgumentCommandNode && CommandUtil.checkForCustomSuggestions(rootSuggestion)) {
                rootSuggestion.addChild(this.impl$cloneArgumentCommandNodeWithoutSuggestions((ArgumentCommandNode)value));
            } else {
                rootSuggestion.addChild((CommandNode)value);
            }
            return map.put(key, value);
        }
        return null;
    }

    @Redirect(method={"fillUsableCommands"}, at=@At(value="INVOKE", target="Lcom/mojang/brigadier/tree/CommandNode;addChild(Lcom/mojang/brigadier/tree/CommandNode;)V", remap=false))
    private void impl$preventAddChild(CommandNode<SharedSuggestionProvider> root, CommandNode<SharedSuggestionProvider> newChild) {
    }

    @Redirect(method={"fillUsableCommands"}, at=@At(value="INVOKE", target="Lcom/mojang/brigadier/tree/CommandNode;canUse(Ljava/lang/Object;)Z", remap=false))
    private boolean impl$testPermissionAndPreventRecalculationWhenSendingNodes(CommandNode<CommandSourceStack> commandNode, Object source, CommandNode<CommandSourceStack> rootCommandNode, CommandNode<SharedSuggestionProvider> rootSuggestion, CommandSourceStack sourceButTyped, Map<CommandNode<CommandSourceStack>, CommandNode<SharedSuggestionProvider>> commandNodeToSuggestionNode) {
        ServerPlayer e = (ServerPlayer)sourceButTyped.getEntity();
        Map<CommandNode<CommandSourceStack>, List<CommandNode<SharedSuggestionProvider>>> playerNodes = this.impl$playerNodeCache.get(e);
        List<CommandNode<SharedSuggestionProvider>> existingNodes = playerNodes.get(commandNode);
        if (existingNodes != null) {
            if (!existingNodes.isEmpty()) {
                boolean hasCustomSuggestionsAlready = CommandUtil.checkForCustomSuggestions(rootSuggestion);
                for (CommandNode<SharedSuggestionProvider> node : existingNodes) {
                    if (hasCustomSuggestionsAlready && node instanceof ArgumentCommandNode) {
                        ArgumentCommandNode argNode = (ArgumentCommandNode)node;
                        if (argNode.getCustomSuggestions() != null) {
                            rootSuggestion.addChild(this.impl$cloneArgumentCommandNodeWithoutSuggestions(argNode));
                            continue;
                        }
                    } else if (node instanceof ArgumentCommandNode && ((ArgumentCommandNode)node).getCustomSuggestions() != null) {
                        hasCustomSuggestionsAlready = true;
                    }
                    rootSuggestion.addChild(node);
                }
            }
            return false;
        }
        if (!commandNodeToSuggestionNode.containsKey(commandNode) && !SpongeNodePermissionCache.canUse(rootCommandNode instanceof RootCommandNode, this.impl$commandManager.getDispatcher(), commandNode, sourceButTyped)) {
            playerNodes.put(commandNode, Collections.emptyList());
            return false;
        }
        if (commandNode instanceof SpongeArgumentCommandNode && ((SpongeArgumentCommandNode)commandNode).isComplex()) {
            boolean hasCustomSuggestionsAlready = CommandUtil.checkForCustomSuggestions(rootSuggestion);
            CommandNode<SharedSuggestionProvider> finalCommandNode = ((SpongeArgumentCommandNode)commandNode).getComplexSuggestions(rootSuggestion, commandNodeToSuggestionNode, playerNodes, !hasCustomSuggestionsAlready);
            if (!this.impl$getChildrenFromNode(commandNode).isEmpty()) {
                this.shadow$fillUsableCommands(commandNode, finalCommandNode, sourceButTyped, commandNodeToSuggestionNode);
            }
            return false;
        }
        return true;
    }

    @Redirect(method={"fillUsableCommands"}, at=@At(value="INVOKE", target="Lcom/mojang/brigadier/builder/RequiredArgumentBuilder;suggests(Lcom/mojang/brigadier/suggestion/SuggestionProvider;)Lcom/mojang/brigadier/builder/RequiredArgumentBuilder;", remap=false))
    private RequiredArgumentBuilder<SharedSuggestionProvider, ?> impl$dontAskServerIfSiblingAlreadyDoes(RequiredArgumentBuilder<SharedSuggestionProvider, ?> requiredArgumentBuilder, SuggestionProvider<SharedSuggestionProvider> provider, CommandNode<CommandSourceStack> rootCommandNode, CommandNode<SharedSuggestionProvider> rootSuggestion, CommandSourceStack sourceButTyped, Map<CommandNode<CommandSourceStack>, CommandNode<SharedSuggestionProvider>> commandNodeToSuggestionNode) {
        if (provider != SuggestionProviders.ASK_SERVER || !CommandUtil.checkForCustomSuggestions(rootSuggestion)) {
            requiredArgumentBuilder.suggests(provider);
        }
        return requiredArgumentBuilder;
    }

    @Redirect(method={"fillUsableCommands"}, at=@At(value="INVOKE", target="Lcom/mojang/brigadier/builder/ArgumentBuilder;build()Lcom/mojang/brigadier/tree/CommandNode;", remap=false))
    private CommandNode<SharedSuggestionProvider> impl$createSpongeArgumentNode(ArgumentBuilder<SharedSuggestionProvider, ?> argumentBuilder) {
        if (argumentBuilder instanceof RequiredArgumentBuilder) {
            return new SuggestionArgumentNode((RequiredArgumentBuilder)argumentBuilder);
        }
        return argumentBuilder.build();
    }

    @Override
    public SpongeCommandManager bridge$commandManager() {
        return this.impl$commandManager;
    }

    private Collection<CommandNode<CommandSourceStack>> impl$getChildrenFromNode(CommandNode<CommandSourceStack> parentNode) {
        Collection<CommandNode<CommandSourceStack>> nodes = parentNode instanceof SpongeNode ? ((SpongeNode)parentNode).getChildrenForSuggestions() : parentNode.getChildren();
        return nodes;
    }

    private ArgumentCommandNode<SharedSuggestionProvider, ?> impl$cloneArgumentCommandNodeWithoutSuggestions(ArgumentCommandNode<SharedSuggestionProvider, ?> toClone) {
        RequiredArgumentBuilder builder = toClone.createBuilder();
        builder.suggests(null);
        for (CommandNode node : toClone.getChildren()) {
            builder.then(node);
        }
        return new SuggestionArgumentNode(builder);
    }
}

