/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.boss.enderdragon;

import java.util.Optional;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.explosives.ExplosiveBridge;
import org.spongepowered.common.bridge.world.entity.boss.enderdragon.EndCrystalBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.world.entity.EntityMixin;

@Mixin(value={EndCrystal.class})
public abstract class EndCrystalMixin
extends EntityMixin
implements ExplosiveBridge,
EndCrystalBridge {
    private int impl$explosionStrength = 6;

    @Override
    public Optional<Integer> bridge$getExplosionRadius() {
        return Optional.of(this.impl$explosionStrength);
    }

    @Override
    public void bridge$setExplosionRadius(@Nullable Integer radius) {
        this.impl$explosionStrength = radius == null ? 6 : radius;
    }

    @Redirect(method={"hurt"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;explode(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;Lnet/minecraft/world/level/ExplosionDamageCalculator;DDDFZLnet/minecraft/world/level/Level$ExplosionInteraction;)Lnet/minecraft/world/level/Explosion;"))
    private @Nullable Explosion impl$throwEventWithEntity(Level world, Entity entityIn, DamageSource damageSource, ExplosionDamageCalculator exDamageCalc, double xIn, double yIn, double zIn, float explosionRadius, boolean fire, Level.ExplosionInteraction modeIn) {
        return this.bridge$throwExplosionEventAndExplode(world, entityIn, xIn, yIn, zIn, modeIn.compareTo((Enum)Level.ExplosionInteraction.TNT) <= 0, damageSource);
    }

    @Override
    public @Nullable Explosion bridge$throwExplosionEventAndExplode(Level world, @Nullable Entity nil, double x, double y, double z, boolean smoking, @Nullable DamageSource source) {
        CauseStackManager causeStackManager = PhaseTracker.getCauseStackManager();
        try (CauseStackManager.StackFrame frame = causeStackManager.pushCauseFrame();){
            frame.pushCause(this);
            if (source != null) {
                frame.pushCause(source);
            }
            Explosion explosion = SpongeCommonEventFactory.detonateExplosive(this, org.spongepowered.api.world.explosion.Explosion.builder().location(ServerLocation.of((ServerWorld)world, x, y, z)).radius(this.impl$explosionStrength).shouldPlaySmoke(smoking)).orElse(null);
            return explosion;
        }
    }
}

