/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.item;

import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Item;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.data.SpongeDataHolderBridge;
import org.spongepowered.common.bridge.world.entity.item.ItemEntityBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.config.SpongeGameConfigs;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.data.provider.entity.ItemData;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.world.entity.EntityMixin;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends EntityMixin
implements ItemEntityBridge {
    @Shadow
    private int pickupDelay;
    @Shadow
    private int age;
    private double impl$cachedRadius = -1.0;

    @Shadow
    public abstract ItemStack shadow$getItem();

    @ModifyConstant(method={"mergeWithNeighbours"}, constant={@Constant(doubleValue=0.5)})
    private double impl$changeSearchRadiusFromConfig(double originalRadius) {
        if (this.shadow$level().isClientSide || ((LevelBridge)this.shadow$level()).bridge$isFake()) {
            return originalRadius;
        }
        if (this.impl$cachedRadius == -1.0) {
            double configRadius = ((WorldConfig)((PrimaryLevelDataBridge)this.shadow$level().getLevelData()).bridge$configAdapter().get()).world.itemMergeRadius;
            this.impl$cachedRadius = configRadius < 0.0 ? 0.0 : configRadius;
        }
        return this.impl$cachedRadius;
    }

    @Override
    public int bridge$getPickupDelay() {
        return this.pickupDelay;
    }

    @Override
    public void bridge$setPickupDelay(int delay) {
        this.pickupDelay = delay;
        if (delay == Short.MAX_VALUE) {
            ((SpongeDataHolderBridge)((Object)this)).bridge$offer(ItemData.INFINITE_PICKUP_DELAY, true);
        } else {
            ((SpongeDataHolderBridge)((Object)this)).bridge$remove(ItemData.INFINITE_PICKUP_DELAY);
        }
    }

    @Override
    public int bridge$getDespawnDelay() {
        return this.age != Short.MIN_VALUE ? ((WorldConfig)SpongeGameConfigs.getForWorld((Level)this.shadow$level()).get()).entity.item.despawnRate - this.age : this.age;
    }

    @Override
    public void bridge$setDespawnDelay(int delay) {
        if (delay == Short.MIN_VALUE) {
            this.age = Short.MIN_VALUE;
            ((SpongeDataHolderBridge)((Object)this)).bridge$offer(ItemData.INFINITE_DESPAWN_DELAY, true);
        } else {
            this.age = ((WorldConfig)SpongeGameConfigs.getForWorld((Level)this.shadow$level()).get()).entity.item.despawnRate - delay;
            ((SpongeDataHolderBridge)((Object)this)).bridge$remove(ItemData.INFINITE_DESPAWN_DELAY);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;discard()V")}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;updateInWaterStateAndDoFluidPushing()Z"), to=@At(value="TAIL"))})
    private void impl$fireExpireEntityEventTargetItem(CallbackInfo ci) {
        if (!PhaseTracker.SERVER.onSidedThread() || this.shadow$getItem().isEmpty()) {
            return;
        }
        this.impl$callExpireEntityEvent();
    }

    @ModifyConstant(method={"isMergable"}, constant={@Constant(intValue=6000)})
    private int impl$isMergableUseDespawnRateFromConfig(int originalValue) {
        return ((WorldConfig)SpongeGameConfigs.getForWorld((Level)this.shadow$level()).get()).entity.item.despawnRate;
    }

    @Inject(method={"tryToMerge"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;merge(Lnet/minecraft/world/entity/item/ItemEntity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/item/ItemEntity;Lnet/minecraft/world/item/ItemStack;)V")})
    private void impl$merge(ItemEntity param0, CallbackInfo ci) {
        Cause currentCause = Sponge.server().causeStackManager().currentCause();
        if (Sponge.eventManager().post(SpongeEventFactory.createItemMergeWithItemEvent(currentCause, (Item)((Object)this), (Item)param0))) {
            ci.cancel();
        }
    }
}

