/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.projectile;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.projectile.FishingBobber;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.world.entity.projectile.ProjectileMixin;

@Mixin(value={FishingHook.class})
public abstract class FishingHookMixin
extends ProjectileMixin {
    @Shadow
    private @Nullable net.minecraft.world.entity.Entity hookedIn;
    @Shadow
    private int nibble;
    @Shadow
    @Final
    private int luck;

    @Shadow
    public abstract @Nullable Player shadow$getPlayerOwner();

    @Shadow
    protected abstract void shadow$pullEntity(net.minecraft.world.entity.Entity var1);

    @Inject(method={"setHookedEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetHookedEntity(@Nullable net.minecraft.world.entity.Entity hookedIn, CallbackInfo ci) {
        if (hookedIn != null && SpongeCommon.post(SpongeEventFactory.createFishingEventHookEntity(PhaseTracker.getCauseStackManager().currentCause(), (Entity)hookedIn, (FishingBobber)((Object)this)))) {
            this.hookedIn = null;
            ci.cancel();
        }
    }

    @Overwrite
    public int retrieve(ItemStack stack) {
        Player playerEntity = this.shadow$getPlayerOwner();
        if (!this.shadow$level().isClientSide && playerEntity != null) {
            List<Transaction<ItemStackSnapshot>> transactions;
            int i = 0;
            if (this.nibble > 0) {
                LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)this.shadow$level()).withParameter(LootContextParams.ORIGIN, (Object)this.shadow$position()).withParameter(LootContextParams.TOOL, (Object)stack).withParameter(LootContextParams.THIS_ENTITY, (Object)((FishingHook)this)).withLuck((float)this.luck + playerEntity.getLuck());
                LootTable lootTable = this.shadow$level().getServer().getLootData().getLootTable(BuiltInLootTables.FISHING);
                ObjectArrayList list = lootTable.getRandomItems(lootcontext$builder.create(LootContextParamSets.FISHING));
                transactions = list.stream().map(ItemStackUtil::snapshotOf).map(snapshot -> new Transaction<ItemStackSnapshot>((ItemStackSnapshot)snapshot, (ItemStackSnapshot)snapshot)).collect(Collectors.toList());
                CriteriaTriggers.FISHING_ROD_HOOKED.trigger((ServerPlayer)playerEntity, stack, (FishingHook)this, (Collection)list);
            } else {
                transactions = new ArrayList<Transaction<ItemStackSnapshot>>();
            }
            PhaseTracker.getCauseStackManager().pushCause(playerEntity);
            if (SpongeCommon.post(SpongeEventFactory.createFishingEventStop(PhaseTracker.getCauseStackManager().currentCause(), (FishingBobber)((Object)this), transactions))) {
                return 0;
            }
            if (this.hookedIn != null) {
                this.shadow$pullEntity(this.hookedIn);
                CriteriaTriggers.FISHING_ROD_HOOKED.trigger((ServerPlayer)playerEntity, stack, (FishingHook)this, Collections.emptyList());
                this.shadow$level().broadcastEntityEvent((net.minecraft.world.entity.Entity)((FishingHook)this), (byte)31);
                int n = i = this.hookedIn instanceof ItemEntity ? 3 : 5;
            }
            if (!transactions.isEmpty()) {
                for (Transaction transaction : transactions) {
                    if (!transaction.isValid()) continue;
                    ItemStack itemstack = (ItemStack)((ItemStackSnapshot)transaction.finalReplacement()).createStack();
                    ItemEntity entityitem = new ItemEntity(this.shadow$level(), this.shadow$getX(), this.shadow$getY(), this.shadow$getZ(), itemstack);
                    double d0 = playerEntity.getX() - this.shadow$getX();
                    double d1 = playerEntity.getY() - this.shadow$getY();
                    double d2 = playerEntity.getZ() - this.shadow$getZ();
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    entityitem.setDeltaMovement(d0 * 0.1, d1 * 0.1 + Math.sqrt(d3) * 0.08, d2 * 0.1);
                    this.shadow$level().addFreshEntity((net.minecraft.world.entity.Entity)entityitem);
                    playerEntity.level().addFreshEntity((net.minecraft.world.entity.Entity)new ExperienceOrb(playerEntity.level(), playerEntity.getX(), playerEntity.getY() + 0.5, playerEntity.getZ() + 0.5, this.random.nextInt(6) + 1));
                    if (!itemstack.is(ItemTags.FISHES)) continue;
                    playerEntity.awardStat(Stats.FISH_CAUGHT, 1);
                }
                PhaseTracker.getCauseStackManager().popCause();
                i = Math.max(i, 1);
            }
            if (this.shadow$onGround()) {
                i = 2;
            }
            this.shadow$discard();
            return i;
        }
        return 0;
    }

    @Inject(method={"checkCollision"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/FishingHook;onHit(Lnet/minecraft/world/phys/HitResult;)V")})
    private void impl$callCollideImpactEvent(CallbackInfo ci, HitResult hitResult) {
        if (hitResult.getType() == HitResult.Type.MISS || ((LevelBridge)this.shadow$level()).bridge$isFake()) {
            return;
        }
        if (SpongeCommonEventFactory.handleCollideImpactEvent((net.minecraft.world.entity.Entity)((FishingHook)this), this.impl$getProjectileSource(), hitResult)) {
            this.shadow$discard();
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/FishingHook;discard()V")}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/FishingHook;shouldStopFishing(Lnet/minecraft/world/entity/player/Player;)Z"), to=@At(value="TAIL"))})
    private void impl$expireFishingHookOnLand(CallbackInfo ci) {
        this.impl$callExpireEntityEvent();
    }
}

