/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.projectile;

import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.entity.projectile.explosive.fireball.ExplosiveFireball;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.explosives.ExplosiveBridge;
import org.spongepowered.common.bridge.world.entity.GrieferBridge;
import org.spongepowered.common.bridge.world.entity.projectile.LargeFireballBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.world.entity.projectile.AbstractHurtingProjectileMixin;

@Mixin(value={LargeFireball.class})
public abstract class LargeFireballMixin
extends AbstractHurtingProjectileMixin
implements LargeFireballBridge,
ExplosiveBridge {
    @Shadow
    public int explosionPower;

    @Redirect(method={"onHit"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;explode(Lnet/minecraft/world/entity/Entity;DDDFZLnet/minecraft/world/level/Level$ExplosionInteraction;)Lnet/minecraft/world/level/Explosion;"))
    public @Nullable Explosion impl$throwExplosionEventAndExplode(Level worldObj, @Nullable Entity nil, double x, double y, double z, float strength, boolean flaming, Level.ExplosionInteraction mode) {
        return this.bridge$throwExplosionEventAndExplode(worldObj, nil, x, y, z, strength, flaming, mode);
    }

    @Override
    public Explosion bridge$throwExplosionEventAndExplode(Level worldObj, @Nullable Entity nil, double x, double y, double z, float strength, boolean flaming, Level.ExplosionInteraction mode) {
        boolean griefer = ((GrieferBridge)((Object)this)).bridge$canGrief();
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this);
            ((Projectile)((Object)this)).get(Keys.SHOOTER).ifPresent(shooter -> frame.addContext(EventContextKeys.PROJECTILE_SOURCE, shooter));
            Optional<Explosion> ex = SpongeCommonEventFactory.detonateExplosive(this, org.spongepowered.api.world.explosion.Explosion.builder().location(ServerLocation.of((ServerWorld)worldObj, x, y, z)).sourceExplosive((ExplosiveFireball)((Object)this)).radius(strength).canCauseFire(flaming && griefer).shouldPlaySmoke(mode != Level.ExplosionInteraction.NONE && griefer).shouldBreakBlocks(mode != Level.ExplosionInteraction.NONE && griefer));
            Explosion explosion = ex.orElse(null);
            return explosion;
        }
    }

    @Override
    public Optional<Integer> bridge$getExplosionRadius() {
        return Optional.of(this.explosionPower);
    }

    @Override
    public void bridge$setExplosionRadius(@Nullable Integer radius) {
        this.explosionPower = radius == null ? 1 : radius;
    }
}

