/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.entity.projectile;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.util.DirectionUtil;

@Mixin(value={ProjectileUtil.class})
public abstract class ProjectileUtilMixin {
    @Inject(method={"getHitResultOnMoveVector"}, at={@At(value="RETURN")}, cancellable=true)
    private static void impl$onGetHitResultOnMoveVector(Entity entity, Predicate<Entity> $$1, CallbackInfoReturnable<HitResult> cir) {
        if (!ShouldFire.COLLIDE_BLOCK_EVENT_MOVE) {
            return;
        }
        HitResult hitResult = (HitResult)cir.getReturnValue();
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            BlockState state = entity.level().getBlockState(blockHitResult.getBlockPos());
            if (SpongeCommonEventFactory.handleCollideBlockEvent(state.getBlock(), entity.level(), blockHitResult.getBlockPos(), state, entity, DirectionUtil.getFor(blockHitResult.getDirection()), SpongeCommonEventFactory.CollisionType.MOVE)) {
                Vec3 from = entity.position();
                Vec3 velocity = entity.getDeltaMovement();
                Vec3 to = from.add(velocity);
                Vec3 direction = from.subtract(to);
                cir.setReturnValue((Object)BlockHitResult.miss((Vec3)to, (Direction)Direction.getNearest((double)direction.x, (double)direction.y, (double)direction.z), (BlockPos)BlockPos.containing((Position)to)));
            }
        }
    }
}

