/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.item;

import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ServerItemCooldowns;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.CooldownTracker;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.living.player.CooldownEvent;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.world.item.ItemCooldownsMixin;
import org.spongepowered.common.util.SpongeTicks;

@Mixin(value={ServerItemCooldowns.class})
public abstract class ServerItemCooldownsMixin
extends ItemCooldownsMixin {
    @Shadow
    @Final
    private ServerPlayer player;

    @Shadow
    protected abstract void shadow$onCooldownStarted(Item var1, int var2);

    @Override
    protected int impl$throwSetCooldownEvent(ItemType type, int ticks) {
        if (ticks == 0) {
            return 0;
        }
        Optional<Ticks> beforeCooldown = ((CooldownTracker)((Object)this)).cooldown(type);
        CooldownEvent.Set event = SpongeEventFactory.createCooldownEventSet(PhaseTracker.getCauseStackManager().currentCause(), SpongeTicks.ticksOrInfinite(ticks), SpongeTicks.ticksOrInfinite(ticks), type, (org.spongepowered.api.entity.living.player.server.ServerPlayer)this.player, beforeCooldown);
        if (Sponge.eventManager().post(event)) {
            this.shadow$onCooldownStarted((Item)type, beforeCooldown.map(x -> (int)x.ticks()).orElse(0));
            return -2;
        }
        return SpongeTicks.toSaturatedIntOrInfinite(event.newCooldown());
    }

    @Override
    protected void impl$throwEndCooldownEvent(ItemType type) {
        CooldownEvent.End event = SpongeEventFactory.createCooldownEventEnd(PhaseTracker.getCauseStackManager().currentCause(), type, (org.spongepowered.api.entity.living.player.server.ServerPlayer)this.player);
        Sponge.eventManager().post(event);
    }

    @ModifyVariable(method={"onCooldownStarted"}, at=@At(value="HEAD"), argsOnly=true)
    private int impl$modifyPacketOnInfiniteCooldown(int ticks) {
        if (ticks != -1) {
            return ticks;
        }
        return 0x3FFFFFFF;
    }
}

