/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.chunk;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.data.DataUtil;

@Mixin(value={ChunkSerializer.class})
public abstract class ChunkSerializerMixin {
    @Inject(method={"write"}, at={@At(value="RETURN")})
    private static void impl$writeSpongeChunkData(ServerLevel level, ChunkAccess chunk, CallbackInfoReturnable<CompoundTag> cir) {
        if (!(chunk instanceof LevelChunk)) {
            return;
        }
        CompoundTag compound = (CompoundTag)cir.getReturnValue();
        if (DataUtil.syncDataToTag(chunk)) {
            compound.merge(((DataCompoundHolder)chunk).data$getCompound());
        }
    }

    @Inject(method={"read"}, at={@At(value="RETURN")})
    private static void impl$readSpongeChunkData(ServerLevel level, PoiManager poi, ChunkPos pos, CompoundTag compound, CallbackInfoReturnable<ProtoChunk> cir) {
        Object object = cir.getReturnValue();
        if (!(object instanceof ImposterProtoChunk)) {
            return;
        }
        ImposterProtoChunk imposter = (ImposterProtoChunk)object;
        ((DataCompoundHolder)imposter.getWrapped()).data$setCompound(compound);
        DataUtil.syncTagToData(imposter.getWrapped());
        ((DataCompoundHolder)imposter.getWrapped()).data$setCompound(null);
    }
}

