/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.chunk.storage;

import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.entity.ChunkEntities;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.world.chunk.ChunkEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.level.chunk.storage.IOWorkerBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.level.chunk.storage.SpongeEntityChunk;
import org.spongepowered.common.world.level.chunk.storage.SpongeIOWorkerType;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={EntityStorage.class})
public abstract class EntityStorageMixin {
    @Shadow
    @Final
    private IOWorker worker;
    @Shadow
    @Final
    private ServerLevel level;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void impl$setIOWorkerDimension(CallbackInfo ci) {
        ((IOWorkerBridge)this.worker).bridge$setDimension(SpongeIOWorkerType.ENTITY, (ResourceKey<Level>)this.level.dimension());
    }

    @Inject(method={"lambda$loadEntities$0"}, at={@At(value="RETURN")}, cancellable=true)
    private void impl$onLoadEntities(ChunkPos $$0x, Optional<CompoundTag> $$1, CallbackInfoReturnable<ChunkEntities<Entity>> cir) {
        if (!ShouldFire.CHUNK_EVENT_ENTITIES_LOAD) {
            return;
        }
        Vector3i chunkPos = VecHelper.toVector3i($$0x);
        SpongeEntityChunk entities = new SpongeEntityChunk(this.level, chunkPos, ((ChunkEntities)cir.getReturnValue()).getEntities());
        ChunkEvent.Entities.Load loadEvent = SpongeEventFactory.createChunkEventEntitiesLoad(PhaseTracker.getInstance().currentCause(), entities, chunkPos, (org.spongepowered.api.ResourceKey)this.level.dimension().location());
        SpongeCommon.post(loadEvent);
        @Nullable List<Entity> newList = entities.buildIfChanged();
        if (newList != null) {
            cir.setReturnValue((Object)new ChunkEntities($$0x, newList));
        }
    }

    @ModifyVariable(method={"storeEntities"}, at=@At(value="HEAD"), argsOnly=true)
    private ChunkEntities<Entity> impl$onStoreEntities(ChunkEntities<Entity> $$0) {
        if (!ShouldFire.CHUNK_EVENT_ENTITIES_SAVE_PRE) {
            return $$0;
        }
        Vector3i chunkPos = VecHelper.toVector3i($$0.getPos());
        SpongeEntityChunk entities = new SpongeEntityChunk(this.level, chunkPos, $$0.getEntities());
        ChunkEvent.Entities.Save.Pre saveEvent = SpongeEventFactory.createChunkEventEntitiesSavePre(PhaseTracker.getInstance().currentCause(), entities, chunkPos, (org.spongepowered.api.ResourceKey)this.level.dimension().location());
        if (SpongeCommon.post(saveEvent)) {
            return null;
        }
        @Nullable List<Entity> newList = entities.buildIfChanged();
        if (newList != null) {
            return new ChunkEntities($$0.getPos(), newList);
        }
        return $$0;
    }

    @Inject(method={"storeEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/ChunkEntities;getPos()Lnet/minecraft/world/level/ChunkPos;")}, cancellable=true)
    private void impl$onCancelledEntitySave(ChunkEntities<Entity> $$0, CallbackInfo ci) {
        if ($$0 == null) {
            ci.cancel();
        }
    }
}

