/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.chunk.storage;

import com.mojang.datafixers.util.Either;
import java.util.BitSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.visitors.CollectFields;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.thread.ProcessorHandle;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.util.thread.StrictQueue;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.slf4j.Logger;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.world.chunk.ChunkEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.world.level.chunk.storage.IOWorker$PendingStoreAccessor;
import org.spongepowered.common.bridge.world.level.chunk.storage.IOWorkerBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.world.level.chunk.SpongeUnloadedChunkException;
import org.spongepowered.common.world.level.chunk.storage.SpongeIOWorkerType;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={IOWorker.class})
public abstract class IOWorkerMixin
implements IOWorkerBridge {
    @Shadow
    @Final
    private static Logger LOGGER;
    @Shadow
    @Final
    private AtomicBoolean shutdownRequested;
    @Shadow
    @Final
    private ProcessorMailbox<StrictQueue.IntRunnable> mailbox;
    @Shadow
    @Final
    private RegionFileStorage storage;
    @Shadow
    @Final
    private Map<ChunkPos, IOWorker$PendingStoreAccessor> pendingWrites;
    private @MonotonicNonNull SpongeIOWorkerType impl$type;
    private @MonotonicNonNull ResourceKey<Level> impl$dimension;

    @Shadow
    protected abstract boolean shadow$isOldChunk(CompoundTag var1);

    @Shadow
    protected abstract void shadow$tellStorePending();

    @Override
    public void bridge$setDimension(SpongeIOWorkerType type, ResourceKey<Level> dimension) {
        this.impl$type = type;
        this.impl$dimension = dimension;
    }

    @Inject(method={"runStore"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Ljava/util/concurrent/CompletableFuture;complete(Ljava/lang/Object;)Z")})
    private void impl$onSaved(ChunkPos param0, @Coerce Object param1, CallbackInfo ci) {
        if (this.impl$type == SpongeIOWorkerType.CHUNK) {
            if (ShouldFire.CHUNK_EVENT_BLOCKS_SAVE_POST) {
                Vector3i chunkPos = new Vector3i(param0.x, 0, param0.z);
                ChunkEvent.Blocks.Save.Post postSave = SpongeEventFactory.createChunkEventBlocksSavePost(PhaseTracker.getInstance().currentCause(), chunkPos, (org.spongepowered.api.ResourceKey)this.impl$dimension.location());
                SpongeCommon.post(postSave);
            }
        } else if (this.impl$type == SpongeIOWorkerType.ENTITY && ShouldFire.CHUNK_EVENT_ENTITIES_SAVE_POST) {
            Vector3i chunkPos = new Vector3i(param0.x, 0, param0.z);
            ChunkEvent.Entities.Save.Post postSave = SpongeEventFactory.createChunkEventEntitiesSavePost(PhaseTracker.getInstance().currentCause(), chunkPos, (org.spongepowered.api.ResourceKey)this.impl$dimension.location());
            SpongeCommon.post(postSave);
        }
    }

    @Overwrite
    private CompletableFuture<BitSet> createOldDataForRegion(int x, int z) {
        return this.impl$submitTaskCancellable(() -> {
            try {
                ChunkPos min = ChunkPos.minFromRegion((int)x, (int)z);
                ChunkPos max = ChunkPos.maxFromRegion((int)x, (int)z);
                BitSet oldDataRegions = new BitSet();
                ChunkPos.rangeClosed((ChunkPos)min, (ChunkPos)max).forEach(pos -> {
                    CompoundTag compoundTag;
                    CollectFields fields = new CollectFields(new FieldSelector[]{new FieldSelector(IntTag.TYPE, "DataVersion"), new FieldSelector(CompoundTag.TYPE, "blending_data")});
                    try {
                        IOWorker$PendingStoreAccessor store = this.pendingWrites.get(pos);
                        if (store != null) {
                            if (store.accessor$data() != null) {
                                store.accessor$data().acceptAsRoot((StreamTagVisitor)fields);
                            }
                        } else {
                            this.storage.scanChunk(pos, (StreamTagVisitor)fields);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to scan chunk {}", pos, (Object)e);
                        return;
                    }
                    Tag result = fields.getResult();
                    if (result instanceof CompoundTag && this.shadow$isOldChunk(compoundTag = (CompoundTag)result)) {
                        int regionIndex = pos.getRegionLocalZ() * 32 + pos.getRegionLocalX();
                        oldDataRegions.set(regionIndex);
                    }
                });
                return Either.left((Object)oldDataRegions);
            }
            catch (Exception e) {
                return Either.right((Object)e);
            }
        });
    }

    private <T> CompletableFuture<T> impl$submitTaskCancellable(Supplier<Either<T, Exception>> supplier) {
        CompletableFuture future = this.mailbox.askEither(processor -> new StrictQueue.IntRunnable(0, () -> this.lambda$impl$submitTaskCancellable$2(processor, (Supplier)supplier)));
        if (this.shutdownRequested.get()) {
            future.completeExceptionally(SpongeUnloadedChunkException.INSTANCE);
        }
        return future;
    }

    private /* synthetic */ void lambda$impl$submitTaskCancellable$2(ProcessorHandle processor, Supplier supplier) {
        if (!this.shutdownRequested.get()) {
            processor.tell((Object)((Either)supplier.get()));
        } else {
            processor.tell((Object)Either.right((Object)SpongeUnloadedChunkException.INSTANCE));
        }
        this.shadow$tellStorePending();
    }
}

